<?php
namespace Dalten\WebBundle\Test\Breadcrumbs\Listing\Collection;

use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Entity\Listing;
use Dalten\WebBundle\Breadcrumbs\Breadcrumb;
use Dalten\WebBundle\Breadcrumbs\Listing\Collection\Builder;
use Mockery as m;

class BuilderTest extends \PHPUnit_Framework_TestCase
{
	public function testCollectionBuilderCallsAllPassedInBuildersAndReturnsNotNullResultsInCorrectOrderWhenCreatedFromListing()
	{
		$firstBreadcrumb = new Breadcrumb('', '');
		$secondBreadcrumb = new Breadcrumb('', '');

		$listing = new Listing();

		$builders = array();

		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromListing')->with($listing)->andReturn($firstBreadcrumb);
		$builders[] = $builder;
		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromListing')->with($listing)->andReturn(null);
		$builders[] = $builder;
		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromListing')->with($listing)->andReturn($secondBreadcrumb);
		$builders[] = $builder;

		$collection = new Builder($builders);
		$result = $collection->getBreadcrumbsFromListing($listing);

		$this->assertCount(2, $result);
		$this->assertSame($firstBreadcrumb, current($result));
		$this->assertSame($secondBreadcrumb, next($result));
	}

	public function testCollectionBuilderCallsAllPassedInBuildersAndReturnsNotNullResultsInCorrectOrderWhenCreatedFromFilter()
	{
		$firstBreadcrumb = new Breadcrumb('', '');
		$secondBreadcrumb = new Breadcrumb('', '');

		$filter = new ListingFilter(array());

		$builders = array();

		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->andReturn($firstBreadcrumb);
		$builders[] = $builder;
		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->andReturn(null);
		$builders[] = $builder;
		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->andReturn($secondBreadcrumb);
		$builders[] = $builder;

		$collection = new Builder($builders);
		$result = $collection->getBreadcrumbsFromFilter($filter);

		$this->assertCount(2, $result);
		$this->assertSame($firstBreadcrumb, current($result));
		$this->assertSame($secondBreadcrumb, next($result));
	}
}
