<?php
/**
 * Created by PhpStorm.
 * User: Karel
 * Date: 24. 9. 2014
 * Time: 15:36
 */

namespace Dalten\WebBundle\Tests\Processor\ListingListData;


use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Processor\ListingListData\Data;

class DataTest extends \PHPUnit_Framework_TestCase
{
	private $_emptyFilter;

	public function setUp()
	{
		$this->_emptyFilter = new ListingFilter(array());
	}

	/**
	 * @expectedException \InvalidArgumentException
	 */
	public function testExceptionIsThrownWhenInvalidSortingFieldIsProvided()
	{
		new Data($this->_emptyFilter, false, false, false, false, array(), 1, 'bagr', false);
	}

	public function testPropertiesAreSetCorrectly()
	{
		$data = new Data(
			$this->_emptyFilter, false, false, 0, false, array(), 1, Data::ORDER_BY_PUBLISHED_DATE, false
		);

		$this->assertFalse($data->isDiscounted());
		$this->assertFalse($data->isFavorite());
		$this->assertFalse($data->isForeign());
		$this->assertFalse($data->isOpenDay());
		$this->assertFalse($data->isOrderedByPrice());
		$this->assertFalse($data->isInAscendingOrder());
		$this->assertTrue($data->isOrderedByPublishedDate());
		$this->assertSame(array(), $data->getFavoriteListingIds());
		$this->assertSame(1, $data->getCurrentPageNumber());
		$this->assertSame($this->_emptyFilter, $data->getFilter());

		$data = new Data(
			$this->_emptyFilter, true, true, true, true, array(1), 2, Data::ORDER_BY_PRICE, true
		);

		$this->assertTrue($data->isDiscounted());
		$this->assertTrue($data->isFavorite());
		$this->assertTrue($data->isForeign());
		$this->assertTrue($data->isOpenDay());
		$this->assertTrue($data->isOrderedByPrice());
		$this->assertTrue($data->isInAscendingOrder());
		$this->assertFalse($data->isOrderedByPublishedDate());
		$this->assertSame(array(1), $data->getFavoriteListingIds());
		$this->assertSame(2, $data->getCurrentPageNumber());
		$this->assertSame($this->_emptyFilter, $data->getFilter());

	}
}
