<?php
/**
 * Created by PhpStorm.
 * User: Karel
 * Date: 8. 12. 2014
 * Time: 16:34
 */

namespace Dalten\WebBundle\Tests\Processor\SeoUrl;

use Dalten\WebBundle\Processor\SeoUrl\CanonicalQueryParamsGenerator;

class CanonicalQueryParamsGeneratorTest extends \PHPUnit_Framework_TestCase
{
	private $_allowedFields = array('test', 'bagr', 'regions');
	private $_attributes = array('_route' => 'Office.List', '_test' => 'hidden');

	public function testProcessorCanReorderAndWhitelistQueryParams()
	{
		$params = array('test' => 'bude na konci', 'neco' => 'tohle zmizi', 'bagr' => 'prvni');
		$expected = array('bagr' => 'prvni', 'test' => 'bude na konci');

		$helper = new CanonicalQueryParamsGenerator($this->_allowedFields);

		$this->assertSame($expected, $helper->getCanonicalQueryParamsForRedirect($params, $this->_attributes));
	}

	public function testProcessorPassesNotHiddenAttributes()
	{
		$params = array('test' => 'bude na konci', 'bagr' => 'prvni');

		$helper = new CanonicalQueryParamsGenerator($this->_allowedFields);

		$result = $helper->getCanonicalQueryParamsForRedirect(
			$params, array_merge(array('neco' => 'ahoj'), $this->_attributes)
		);

		$this->assertArrayHasKey('neco', $result);
		$this->assertSame('ahoj', $result['neco']);
	}

	public function testHelperReturnsNullIfNoRedirectIsNeeded()
	{
		$params = array('bagr' => 'prvni', 'test' => 'bude na konci');

		$helper = new CanonicalQueryParamsGenerator($this->_allowedFields);

		$this->assertNull($helper->getCanonicalQueryParamsForRedirect($params, $this->_attributes));
		$this->assertNull($helper->getCanonicalQueryParamsForRedirect(array(), $this->_attributes));
	}
}
