<?php
namespace Dalten\Tests\WebBundle\Twig\Extensions\Extension;

use Symfony\Component\HttpFoundation\Request;

use Dalten\WebBundle\Twig\Extensions\Extension\Pagination;

/**
 * @group dalten
 */
class PaginationTest extends \PHPUnit_Framework_TestCase
{
	/**
	 * @var Pagination
	 */
	private $_extension;

	public function setUp()
	{
		$this->_extension = new Pagination();
	}

	public function testGetFunctions()
	{
		$result = $this->_extension->getFunctions();

		$expectedMethods = array(
			'pagination_next_page', 'pagination_prev_page', 'pagination_custom_page', 'pagination_items_on_page'
		);
		foreach ($expectedMethods as $methodName) {
			$this->assertArrayHasKey($methodName, $result);
			$this->assertInstanceOf('Twig_Function_Method', $result[$methodName]);
		}
	}

	public function testGetName()
	{
		$this->assertEquals('pagination', $this->_extension->getName());
	}

	/**
	 * @param Request $request
	 * @param         $count
	 * @param         $variable
	 * @param         $expectedResult
	 *
	 * @dataProvider increaseDataProvider
	 */
	public function testNextPage(Request $request, $count, $variable, $expectedResult)
	{
		$result = $this->_extension->increasePageNumber($request, $count, $variable);

		$this->assertEquals($expectedResult, $result);
	}

	public function increaseDataProvider()
	{
		return array(
			array(
				(new Request(array('page' => 33))), // $resuest
				2, // $count
				'page', // $variable,
				\http_build_query(array('page' => 35))
			),
			array(
				(new Request(array('form' => array('blah' => 'kkkk'), 'stranka' => 42))), // $resuest
				1, // $count
				'stranka', // $variable,
				\http_build_query(array('form' => array('blah' => 'kkkk'), 'stranka' => 43))
			),
			array(
				(new Request(array('form' => array('blah' => 'kkkk')))), // $resuest
				1, // $count
				'stranka', // $variable,
				\http_build_query(array('form' => array('blah' => 'kkkk'), 'stranka' => 2))
			),
			array(
				(new Request(array('form' => array('blah' => 'kkkk'), 'page' => 0))), // $resuest
				0, // $count
				'page', // $variable,
				\http_build_query(array('form' => array('blah' => 'kkkk'), 'page' => 2))
			),
		);
	}

	/**
	 * @param Request $request
	 * @param         $count
	 * @param         $variable
	 * @param         $expectedResult
	 *
	 * @dataProvider degradingDataProvider
	 */
	public function testDecreasePageNumber(Request $request, $count, $variable, $expectedResult)
	{
		$result = $this->_extension->decreasePageNumber($request, $count, $variable);

		$this->assertEquals($expectedResult, $result);
	}

	public function degradingDataProvider()
	{
		return array(
			array(
				new Request(array('page' => 4)), // $request
				1, // $page
				'page', // $variable
				\http_build_query(array('page' => 3)) // $expectedResult
			),
			array(
				new Request(array('stranka' => 42)), // $request
				1, // $page
				'stranka', // $variable
				\http_build_query(array('stranka' => 41)) // $expectedResult
			),
			array(
				new Request(array('blah' => 666, 'page' => 4)), // $request
				1, // $page
				'page', // $variable
				\http_build_query(array('blah' => 666, 'page' => 3)) // $expectedResult
			),
			array(
				new Request(), // $request
				1, // $page
				'page', // $variable
				'' // $expectedResult
			),
			array(
				new Request(array('page' => 1)), // $request
				1, // $page
				'page', // $variable
				'' // $expectedResult
			),
		);
	}

	/**
	 *
	 * @dataProvider setVariableDataProvider
	 */
	public function testCustomPageNumber(Request $request, $value, $variable, $expectedResult)
	{
		$result = $this->_extension->customPageNumber($request, $value, $variable);
		$this->assertEquals($expectedResult, $result);
	}

	public function setVariableDataProvider()
	{
		return array(
			array(
				new Request(array('promena' => 'stranka')), // $request
				11, // $value
				'promena', // $variable
				'promena=11' // $expectedResult
			),
			array(
				new Request(array('promena' => 'straka')), // $request
				12, // $value
				'promena', // $variable
				'promena=12' // $expectedResult
			),
		);
	}

	/**
	 *
	 * @dataProvider setRecordsOnPageDataProvider
	 */
	public function testSetRecordsOnPage(Request $request, $value, $variable, $expectedResult)
	{
		$result = $this->_extension->recordsOnPageCount($request, $value, $variable);
		$this->assertEquals($expectedResult, $result);
	}

	public function testSetRecordsOnPageUnsetsPageNumber()
	{
		$pageName = 'brzlik';
		$recordsOnPageName = 'ptacek';
		$request = new Request(array('brzlik' => 3));

		$value = 'brk';
		$result = $this->_extension->recordsOnPageCount($request, $value, $recordsOnPageName, $pageName);
		$this->assertEquals("$recordsOnPageName=$value", $result);
	}

	public function setRecordsOnPageDataProvider()
	{
		return array(
			array(
				new Request(), // $request
				'straka', // $value
				'ptak', // $variable
				'ptak=straka' // $expectedResult
			),
			array(
				new Request(array('ptak' => 'ohnivak')), // $request
				'straka', // $value
				'ptak', // $variable
				'ptak=straka' // $expectedResult
			),
		);
	}
}
