README
======

Co je DaltenWebBundle?
-----------------

DaltenWebBundle obsahuje některé ze společných funkcionalit jednotlivých realitních webů. Samostatné komponenty
 mohou být použity jednotlivě.

Instalace
------------

Instalace WebBundle probíhá přes composer.

Balíček není na packagistu, čili napřed musíme přidat do composer.json náš repozitář:

```json
{    
    "repositories": [
        {
            "type": "git",
            "url": "ssh://git@develop.dalten.com:1022/dalten/web.git"
        }
    ]
}
```


V současné době číslujeme knihovnu od verze 1.0, byť určitě není production-ready. Důvodem je management potenciálních BC breaks.

K instalaci tedy potřebujeme:
```bash
composer require dalten/web ~1.0
```

Následně je potřeba v ```AppKernel.php``` inicializovat ```DaltenWebBundle```.

Dokumentace
-------------

Jednotlivé vlastnosti jsou popsány níže. Konfigurace vlastností se děje v ```app/Resources/configs/config.yml```.
Z důvodu dopředné kompatibility je nutné všechny features explicitně aktivovat. [1]

Pokud tedy chceme všechny features, pak bude v config.yml následující základ:
```yml
dalten_web:
    listing_seo_routes: ~
    listing_list_title_generator: ~
    default_email_config: ~
    property_display_provider: ~
    localisation: ~
    breadcrumbs: ~
```

Všechny features jsou nastaveny tak, aby k jejich používání stačila pouze aktivace. Další možnosti konfigurace jsou
tedy nepovinné.

### Obecně používané vlastnosti

Samotné zapnutí DaltenWebBundle přidá do DI containeru následující parametry:

* ```locality.counties.slugs``` - mapa id krajů na jejich slugy (ČR)
* ```locality.counties.labels``` - mapa id krajů na jejich názvy (ČR)
* ```locality.counties.all_counties_slug``` - slug pro případ, kdy jsou vybrány všechny kraje \[ceska-republika\]
* ```locality.counties.all_counties_label``` - label pro případ, kdy jsou vybrány všechny kraje \[celá ČR\]
* ```locality.county_to_region_map.labels``` - mapa id krajů na id regionů (okres) na jejich labely (ČR)

Tyto parametry jsou používány zbytkem bundlu. V případě potřeby (např. při požadavku na obsluhu jiného státu než je ČR)
je možné hodnoty těchto parametrů přepsat. Musí ale být zachována jejich struktura.

### SEO routy pro výpisy nabídek

Klíč v configu je ```listing_seo_routes```. Po aktivaci přidá do containeru services s id 
```listing_seo_route_matcher.cs``` a ```listing_seo_route_matcher.en```, které umožňují generování SEO URL
z předaného filtru nabídek. Jedná se o instance třídy ```\Dalten\WebBundle\SeoRoute\FragmentCollection```. Na ní zle následně volat metody ```getBreadcrumbsFromFilter``` nebo ```getBreadcrumbsFromListing```. Vráceny jsou dobrečky, tj. pole instancí ```\Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface```.

#### Příklad kompletní konfigurace této feature
```yml
dalten_web:
    listing_seo_routes:
        route_definitions:
            název_routy: [param1, param2]
            název_routy2: [param1, param3]
        locales: [cs, en]
```

#### Popis parametrů

**route_definitions**

Pole definic pro ```\Dalten\WebBundle\SeoRoute\FragmentCollection```.
Výchozí hodnotou je sada matcherů z původního DaltenWebu. Měla by být postačující pro použití ve většině webů.
Z důvodu dopředné kompatibility není možné použití defaultních matcherů s vlastními definicemi rout
(použití vlastních definic rout automaticky vyřadí defaultní nastavení matcherů). [2]

Každý matcher vrací seznam názvů parametrů, které matchnul. Pokud se podaří takto složit všechny parametry
z ```matched_params``` (klíč pole ```route_definitions```), pak bude uživatel přesměrován na routu ```route_name```
(hodnota pole ```route_definitions```).

**locales**
Seznam použitých locales. Výchozí hodnotou je [cs, en]. Na základě této hodnoty jsou nastaveny služby do containeru:

* ```cs``` => ```listing_seo_route_matcher.cs```
* ```en``` => ```listing_seo_route_matcher.en```.

### Drobečková navigace

Klíč v configu je ```breadcrumbs```. Po aktivaci přidá do containeru services s id 
```breadcrumb.listing.builder```, které umožňují generování drobečkové navigace
z předaného filtru nabídek. Jedná se o instance třídy ```\Dalten\WebBundle\Breadcrumbs\Listing\Collection\Builder```.

#### Příklad kompletní konfigurace této feature
```yml
dalten_web:
    breadcrumbs: ~
```

Konfigurace je zatím bez jakýchkoli možností, budou řešeny dle potřeby.

### Generování titulků výpisů nemovitostí

Klíč v configu je ```listing_list_title_generator```. Po aktivaci přidá do containeru service s id 
```listing_list_title_generator```, která umožňuje generování titulku výpisu z předaného filtru nabídek.
Jedná se o instanci třídy ```\Dalten\WebBundle\Processor\TitleGenerator\ListingList\Base```.

#### Příklad kompletní konfigurace této feature
```yml
dalten_web:
    listing_list_title_generator:
        codebooks:
            listing_type_default:
                0: nemovitosti
                1: farmy, statky, zemědělské usedlosti
                2: komerční nemovitosti
                3: pozemky
                4: byty
                5: historické objekty
                6: rodinné domy
                7: hotely, penziony, restaurace
                8: nájemní (činžovní) domy
                9: komerční prostory
                10: chaty a chalupy
                11: malé objekty a garáže
                92: ostatní nemovitosti
        all_counties_title: fšude
        special_titles:
            -
              requirements: { listing_type : [], advert_type: [] }
              title_parts: { advert_type: '', listing_type: 'Baráky', suffix: '' }
        other_listing_type_ids: [1, 5, 10, 11]
```

#### Popis parametrů

**codebooks**

Pole číselníků pro generování nadpisů ```\Dalten\WebBundle\Processor\TitleGenerator\ListingList\Base```.
Výchozí hodnotou je soubor číselníků, pokrývající hlavní use-cases. Pod je možné nahradit jen některé z číselníků
(ostatní zůstanou defaultní), ale není možné nahradit pouze jednu hodnotu defaultního číselníku. Ve výše
uvedeném příkladu dokumentace bude změněn pouze číselník ```listing_type_default```, ostatní zůstanou v defaultním
tvaru.

Povolené klíče (číselníky) jsou:
* ```listing_type_default```
* ```listing_type_sale```
* ```listing_type_lease```
* ```flat_kind```
* ```estate_kind```
* ```hotel_kind_default```
* ```hotel_kind_sale```
* ```hotel_kind_lease```
* ```office_kind_default```
* ```office_kind_sale```
* ```office_kind_lease```
* ```object_kind```.

**all_counties_title**

Text, uvedený v případě vybrání všech krajů najednou. Default je prázdný string. Tento text bude použit pouze pokud
jsou vybrány všechny kraje, nikoli pokud není vybrán žádný.

**special_titles**

Pole speciálních titulků. Definice je složena z klíčů ```requirements``` (mapa názvů vlastností filtru na
pole jejich požadovaných hodnot) a ```title_parts``` (mapa názvů části titulku na text dané části titulku &ndash;
v tomto uvedené části titulku již nebudou dále generovány).

**other_listing_type_ids**

Pole id typů nemovitosti, které jsou zahrnuty pod titulek "ostatní nemovitosti". Default: [1, 5, 10, 11].


### Převádění názvů a hodnot vlastností nabídek na text

Klíč v configu je ```property_display_provider```. Po aktivaci přidá do containeru service s id 
```property_display_provider.listing```, která umožňuje převod názvů a hodnot vlastností nabídek na text.
Jedná se o instanci třídy ```\Dalten\WebBundle\Processor\PropertyDisplayProvider\ListingDetail```.
Přidána je také obecná verze této třídy ( instance třídy ``\Dalten\WebBundle\Processor\PropertyDisplayProvider\Base``` 
pod klíčem ```property_display_provider.base```).

#### Příklad kompletní konfigurace této feature
```yml
dalten_web:
    property_display_provider:
        allowed_locales:
            cs: czech
            en: english
        listing_type_to_area_map:
	        1: nemovitost_plocha_uzitna
	        2: nemovitost_plocha_celkova
	        3: nemovitost_plocha_celkova
	        4: nemovitost_plocha_celkova
	        5: nemovitost_plocha_uzitna
	        6: nemovitost_plocha_uzitna
	        7: nemovitost_plocha_uzitna
	        8: nemovitost_plocha_celkova
	        9: nemovitost_plocha_kancelari
	        10: nemovitost_plocha_uzitna
	        11: nemovitost_plocha_celkova
        displayed_properties_config:
            start: []
            type_3: # pozemky
                - nemovitost_dispozice
                - nemovitost_poloha_objektu
                - nemovitost_druh_pozemku
                - nemovitost_plocha_celkova
                - nemovitost_stavba_na_pozemku
                - nemovitost_stav_objektu
                - nemovitost_druh_stavby
                - nemovitost_plocha_zastavena
                - nemovitost_inzenyrske_site
                - nemovitost_vlastnictvi
                - nemovitost_typ
                - nemovitost_energeticky_stitek
                - nemovitost_merna_rocni_spotreba
```

#### Popis parametrů

**allowed_locales**

Mapa kódů jazyků na jejich suffix v tabulce variables (tj. ```{cs: czech, en: english, ru: russian}```).
Výchozí hodnota je ```{cs: czech, en: english}```.

**displayed_properties_config**

Mapa, kde klíč specifikuje typ skupiny vlastností a hodnotami jsou pole vlastností nabídky v názvech dle staré DB.

Povolené skupiny vlastností jsou:

* ```start``` Položky na začátku výpisu bez ohledu na typ nemovitosti.
* ```type_1``` Položky pro typ nemovitosti 1.
* ```type_...``` Stejně jako výše, ale pro ostatní typy nemovitostí.
* ```type_default``` Pro typy nemovitostí, které nemají svůj vlastní ```type_X``` klíč.
* ```end``` Položky na konci výpisu bez ohledu na typ nemovitosti.

Výchozí hodnotou je taková obvyklá kombinace pro naše weby. :)

**listing_type_to_area_map**

Mapa id nemovitosti na název položky s plochou (v tvaru z DB, nikoli z entity). Vychozí hodnotou je klasická
mapa z našich webů.

### Defaultní config swiftmaileru

Klíč v configu je ```default_email_config_provider```. Po aktivaci přidá do containeru parametry s id 
```mailer_transport```, ```mailer_host```, ```mailer_user``` a ```mailer_password```, které jsou následně užívány pro _SwiftMailer_.

#### Příklad kompletní konfigurace této feature
```yml
dalten_web:
    default_email_config_provider: ~
```

#### Upozornění
Při použití této feature je nutné registrovat ```DaltenWebBundle``` před ```SwiftMailerBundle``` v ```AppKernel.php```. 


--------------------------

[1]: V opačném případě by nám mohly globálně aktivované nové features rozbít staré weby po updatu závislostí. 

[2]: Toto je teoreticky možné obejít nastavením interních parametrů bundlu, ale je to silně nedoporučováno z důvodu
dopředné kompatibility.
