<?php
namespace Dalten\Util\Base64;

use Dalten\Util\Base64\Exception\InvalidFormat;

/**
 * Dekóduje base64 řetězec a vrátí jeho MIME TYPE.
 */
class Base64
{
	private $_buffer;

	/**
	 * Dekóduje řetězec kódovaný do base64 a vrátí instanci třídy.
	 *
	 * @param string $data Řetězec kódovaný v base64.
	 *
	 * @return Base64
	 * @throws Exception\InvalidFormat
	 */
	public static function decode($data)
	{
		$buffer = \base64_decode($data, true);
		if ($buffer === false) {
			throw new InvalidFormat('Špatný base64 formát.');
		}


		$self = new self();
		$self->_buffer = $buffer;
		return $self;
	}

	/**
	 * Vrátí MIME TYPE dekódovaného řetězce.
	 *
	 * @return string
	 */
	public function getMimeType()
	{
		$finfo = new \finfo(FILEINFO_MIME_TYPE);
		return $finfo->buffer($this->_buffer);
	}

	/**
	 * Vrátí dekódovaná data.
	 *
	 * @return mixed
	 */
	public function getBuffer()
	{
		return $this->_buffer;
	}
}
