<?php

namespace Dalten\WebBundle\Breadcrumbs\Company\Builder;

use Dalten\Util\StringHelper;
use Dalten\WebBundle\Filter\CompanyFilter;
use Dalten\WebBundle\Entity\Company;
use Dalten\WebBundle\Breadcrumbs\Breadcrumb;
use Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface;
use Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyAndRegionHelper;

/**
 * Tvořič drobečků na základě předchozího krajového drobečku a regionu.
 */
class OfficeListAndCountyAndRegion implements BuilderInterface
{
	/**
	 * Helper na tvoření drobku s regionem.
	 *
	 * @var array
	 */
	private $_helper;

	/**
	 * Tvořič drobku s krajem.
	 *
	 * @var OfficeListAndCounty
	 */
	private $_countyBreadcrumbBuilder;

	/**
	 * Nastavuje závislsoti.
	 *
	 * @param OfficeListAndCounty   $countyBreadcrumbBuilder Tvořič drobku s krajem.
	 * @param CountyAndRegionHelper $helper                  Helper na tvoření drobku s regionem.
	 */
	public function __construct(OfficeListAndCounty $countyBreadcrumbBuilder, CountyAndRegionHelper $helper)
	{
		$this->_helper = $helper;
		$this->_countyBreadcrumbBuilder = $countyBreadcrumbBuilder;
	}

	/**
	 * Vytvoří drobka z vyplněného modelu firmy.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * POZOR: Drobek se vytváří pouze z filtru. Dle firmy vrátí vždy null.
	 *
	 * @param Company $company Model firmy.
	 *
	 * @return null Null - drobek se pro modely nevytváří.
	 */
	public function getBreadcrumbFromCompany(Company $company)
	{
		return null;
	}

	/**
	 * Vytvoří drobka z vyplněného filtru nabídek.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * @param CompanyFilter $filter Vyplněný filtr nabídek.
	 *
	 * @return Breadcrumb|null Drobek nebo null.
	 */
	public function getBreadcrumbFromFilter(CompanyFilter $filter)
	{
		$previousBreadcrumb = $this->_countyBreadcrumbBuilder->getBreadcrumbFromFilter($filter);

		if ($previousBreadcrumb === null) {
			return null;
		}

		return $this->_helper->getBreadcrumbFromFilter($filter, $previousBreadcrumb);
	}
}
