<?php

namespace Dalten\WebBundle\Breadcrumbs\Listing\Builder;

use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Entity\Listing;
use Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface;
use Dalten\WebBundle\Breadcrumbs\Listing\Breadcrumb\PriceRangeBreadcrumb;
use Symfony\Bundle\FrameworkBundle\Routing\Router;

/**
 * Tvořič drobečků na základě typu nemovitosti a zakázky.
 */
class ListingAndAdvertTypeAndPrice implements BuilderInterface
{
	/**
	 * Konfigurace.
	 *
	 * @var array
	 */
	private $_config;

	/**
	 * Tvořič poddrobečku.
	 *
	 * @var ListingAndAdvertType
	 */
	private $_listingAndAdvertTypeBuilder;

	/**
	 * Nastavuje konfiguraci.
	 *
	 * Konfigurační pole by mělo mít klíče routeName a pole advertTypeMap a listingTypeMap, ve kterých je každý prvek
	 * pole s klíči label a routeParams.
	 *
	 * @param ListingAndAdvertType $listingAndAdvertTypeBuilder Tvořič poddrobečku.
	 * @param array                $config                      Pole nastavení.
	 *
	 */
	public function __construct(ListingAndAdvertType $listingAndAdvertTypeBuilder, array $config)
	{
		$this->_config = $config;
		$this->_listingAndAdvertTypeBuilder = $listingAndAdvertTypeBuilder;
	}

	/**
	 * Vytvoří drobka z vyplněného modelu nabídky.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * @param Listing $listing Model nabídky.
	 *
	 * @return PriceRangeBreadcrumb|null Drobek nebo null.
	 */
	public function getBreadcrumbFromListing(Listing $listing)
	{
		// Pro nabídku neumíme rozmezí ceny.
		return null;
	}

	/**
	 * Vytvoří drobka z vyplněného filtru nabídek.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * @param ListingFilter $filter Vyplněný filtr nabídek.
	 *
	 * @return PriceRangeBreadcrumb|null Drobek nebo null.
	 */
	public function getBreadcrumbFromFilter(ListingFilter $filter)
	{
		$previousBreadcrumb = $this->_listingAndAdvertTypeBuilder->getBreadcrumbFromFilter($filter);
		if ($previousBreadcrumb === null) {
			return null;
		}

		return $this->_getBreadcrumb($previousBreadcrumb, (int) $filter->price_min, (int) $filter->price_max);
	}

	/**
	 * Vytvoří model drobečku dle předaného předchozího drobku a omezení ceny a vrátí jej.
	 *
	 * @param BreadcrumbInterface $listingAndAdvertTypeBreadcrumb Výchozí drobek.
	 * @param int                 $priceFrom                      Minimální cena.
	 * @param int                 $priceTo                        Maximální cena.
	 *
	 * @return null|PriceRangeBreadcrumb Drobek nebo null.
	 */
	private function _getBreadcrumb(BreadcrumbInterface $listingAndAdvertTypeBreadcrumb, $priceFrom, $priceTo)
	{
		$config = $this->_config['priceLimitTypes'];

		if (empty($priceFrom) && empty($priceTo)) {
			return null;
		} elseif (empty($priceTo)) {
			$priceRangeConfig = $config['min'];
			$routeParams = array('price_from' => $priceFrom);
		} elseif (empty($priceFrom)) {
			$priceRangeConfig = $config['max'];
			$routeParams = array('price_to' => $priceTo);
		} else {
			$priceRangeConfig = $config['both'];
			$routeParams = array('price_from' => $priceFrom, 'price_to' => $priceTo);
		}

		$params = array_merge($listingAndAdvertTypeBreadcrumb->getRouteParams(), $routeParams);

		return new PriceRangeBreadcrumb(
			$priceRangeConfig['label'], $priceRangeConfig['routeName'], $params, $priceFrom, $priceTo
		);
	}
}
