<?php

namespace Dalten\WebBundle\Breadcrumbs\Listing\Collection;

use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Entity\Listing;
use Dalten\WebBundle\Breadcrumbs\Listing\Builder\BuilderInterface;
use Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface;

/**
 * Tvořič kolekcí drobečků.
 */
class Builder
{
	/**
	 * Pole tvořičů drobečků.
	 *
	 * @var BuilderInterface[]
	 */
	private $_builders;

	/**
	 * Nastavuje pole builderů drobečků.
	 *
	 * @param BuilderInterface[] $builders Tvořiče drobečků.
	 */
	public function __construct(array $builders = array())
	{
		$this->_builders = $builders;
	}

	/**
	 * Vytvoří pole drobečků z nabídky.
	 *
	 * @param Listing $listing Model nabídky.
	 *
	 * @return BreadcrumbInterface[] Drobky.
	 */
	public function getBreadcrumbsFromListing(Listing $listing)
	{
		$crumbs = array();
		foreach ($this->_builders as $builder) {
			$crumbs[] = $builder->getBreadcrumbFromListing($listing);
		}

		return array_filter($crumbs);
	}

	/**
	 * Vytvoří pole drobečků z filtru nabídek.
	 *
	 * @param ListingFilter $filter Filtr nabídek.
	 *
	 * @return BreadcrumbInterface[] Drobky.
	 */
	public function getBreadcrumbsFromFilter(ListingFilter $filter)
	{
		$crumbs = array();
		foreach ($this->_builders as $builder) {
			$crumbs[] = $builder->getBreadcrumbFromFilter($filter);
		}

		return array_filter($crumbs);
	}
}
