<?php
namespace Dalten\WebBundle\DependencyInjection\Feature;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

/**
 * Created by PhpStorm.
 * User: karel
 * Date: 14.04.2016
 * Time: 10:58
 */
class Localisation implements FeatureInterface
{
	private $_featureAliases = [];

	/**
	 * Localisation constructor.
	 *
	 * @param array $featureAliases
	 */
	public function __construct(array $featureAliases)
	{
		$this->_featureAliases = $featureAliases;
	}

	public function load(array $featureConfig, ContainerBuilder $container)
	{
		$loader = new YamlFileLoader(
			$container,
			new FileLocator(__DIR__ . '/../../Resources/config/feature/localisation')
		);

		if ($featureConfig['provider'] == 'symfony') {
			$loader->load('translator_symfony.yml');
		} elseif ($featureConfig['provider'] == 'jms') {
			$loader->load('translator_jms.yml');
		} else {
			throw new \InvalidArgumentException(sprintf('Neznámý provider překladu "%s"', $featureConfig['provider']));
		}

		$paramsToTranslate = $featureConfig['parameter_paths_to_translate'];

		foreach ($this->_featureAliases as $alias) {
			$paramName = '_translations.config_values_to_translate.' . $alias;
			if ($container->hasParameter($paramName)) {
				$paramsToTranslate = array_merge($paramsToTranslate, $container->getParameter($paramName));
			}
		}

		$container->setParameter('translations.config_values_to_translate', $paramsToTranslate);

	}
}
