<?php
namespace Dalten\WebBundle\DependencyInjection\Feature;

use Symfony\Component\Config\Definition\Exception\InvalidConfigurationException;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Created by PhpStorm.
 * User: karel
 * Date: 14.04.2016
 * Time: 10:58
 */
class PropertyDisplayProvider implements FeatureInterface
{
	public function load(array $featureConfig, ContainerBuilder $container)
	{
		$loader = new YamlFileLoader(
			$container,
			new FileLocator(__DIR__ . '/../../Resources/config/feature/property_display_provider')
		);
		$loader->load('config.yml');

		if (isset($featureConfig['allowed_locales']) && is_array($featureConfig['allowed_locales'])) {
			$container->setParameter(
				'_listing_property_display_provider.allowed_locales', $featureConfig['allowed_locales']
			);
		}

		if (isset($featureConfig['listing_type_to_area_map']) && is_array($featureConfig['listing_type_to_area_map'])) {
			$container->setParameter(
				'_listing.property_display.listing_type_to_area_map', $featureConfig['listing_type_to_area_map']
			);
		}

		if (isset($featureConfig['displayed_properties_config'])
			&& is_array($featureConfig['displayed_properties_config'])) {
			$container->setParameter(
				'_listing.property_display.displayed_properties_config', $featureConfig['displayed_properties_config']
			);
		}
	}
}
