<?php

namespace Dalten\WebBundle\Entity;

/**
 * Entita přílohy (fotka / dokument).
 *
 * @property int    $parent_id       Id rodičovského prvku.
 * @property int    $parent_type     Typ rodičovského prvku (konstanty třídy).
 * @property int    $attachment_type Typ přílohy (konstanty třídy).
 * @property int    $category_id     Id kategorie dokumentu.
 * @property string $file_name       Název souboru (původní).
 * @property string $path            Relativní cesta k souboru.
 * @property int    $width           Šířka fotky.
 * @property int    $height          Výška fotky.
 * @property string $description     Popis přílohy.
 * @property int    $order           Pořadí přílohy.
 */
abstract class Attachment implements EntityWithLegacyData
{
	use LegacyDataMethods;

	const TYPE_IMAGE = 1;
	const TYPE_DOCUMENT = 2;

	const PARENT_TYPE_LISTING = 1;
	const PARENT_TYPE_DEV_PROJECT = 2;

	/**
	 * @var integer
	 */
	private $id;
	/**
	 * @var integer
	 */
	private $_id_parent;

	/**
	 * @var integer
	 */
	private $_typ_parent;

	/**
	 * @var integer
	 */
	private $_typ_prilohy;

	/**
	 * @var integer
	 */
	private $_typ_kategorie;

	/**
	 * @var string
	 */
	private $_nazev_souboru;

	/**
	 * @var string
	 */
	private $_soubor;

	/**
	 * @var integer
	 */
	private $_width;

	/**
	 * @var integer
	 */
	private $_height;

	/**
	 * @var string
	 */
	private $_popis;

	/**
	 * @var integer
	 */
	private $_poradi;

	private static $_map = array(
		'parent_id' => '_id_parent',
		'parent_type' => '_typ_parent',
		'attachment_type' => '_typ_prilohy',
		'category_id' => '_typ_kategorie',
		'file_name' => '_nazev_souboru',
		'path' => '_soubor',
		'width' => '_width',
		'height' => '_height',
		'description' => '_popis',
		'order' => '_poradi',
	);

	public function isImage()
	{
		return $this->_typ_prilohy === self::TYPE_IMAGE;
	}

	public function isDocument()
	{
		return $this->_typ_prilohy === self::TYPE_DOCUMENT;
	}
}

