<?php

namespace Dalten\WebBundle\Entity;

/**
 * Entity hodnoty číselníkové proměnné.
 *
 *
 * @property int    $id            Identifikátor proměnné.
 * @property int    $variable_id   Identifikátor proměnné.
 * @property int    $value         Hodnota číselníkové položky.
 * @property int    $order         Pořadí  číselníkové položky.
 * @property bool   $visible       Pořadí číselníkové položky.
 * @property string $label_czech   Český label.
 * @property string $label_english Anglický label.
 * @property string $label_slovak  Slovenský label.
 *
 */
class VariableListValue implements EntityWithLegacyData
{
	use LegacyDataMethods;

	/**
	 * @var integer
	 */
	private $id;

	/**
	 * @var integer
	 */
	private $_id_list;

	/**
	 * @var integer
	 */
	private $_value;

	/**
	 * @var string
	 */
	private $_lang_czech;

	/**
	 * @var string
	 */
	private $_lang_english;

	/**
	 * @var string
	 */
	private $_lang_slovak;

	/**
	 * @var string
	 */
	private $_lang_russian;

	/**
	 * @var bool
	 */
	private $_visible;

	/**
	 * @var integer
	 */
	private $_ord;

	/**
	 * @var Variable
	 */
	private $variable;

	private static $_map = array(
		'variable_id' => '_id_list',
		'value' => '_value',
		'label_czech' => '_lang_czech',
		'label_english' => '_lang_english',
		'label_slovak' => '_lang_slovak',
		'visible' => '_visible',
		'order' => '_ord',
	);

	/**
	 * @return Variable
	 */
	public function getVariable()
	{
		return $this->variable;
	}
}

