<?php
namespace Dalten\WebBundle\Filter;

/**
 * Normalizovaný filtr na omezení adresy nemovitostí.
 *
 * @property int   $county_code  Kód regionu (v ČR kraje).
 * @property int[] $region_codes Pole kódů regionů (v ČR okresy nebo pobvody).
 */
class AddressFilter extends Base
{
	/**
	 * Validuje a ukládá data do filtru.
	 *
	 * @param int   $countyCode  Kód regionu (v ČR kraje).
	 * @param int[] $regionCodes Pole kódů regionů (v ČR okresy nebo pobvody).
	 */
	public function __construct($countyCode, array $regionCodes)
	{
		parent::__construct(
			array('county_code' => (int) $countyCode, 'region_codes' => array_map('intval', $regionCodes))
		);
	}
}
