<?php
namespace Dalten\WebBundle\Twig\Extensions\Extension;

use Dalten\WebBundle\Processor\Codebooks\CodebookProvider;
use Dalten\WebBundle\Processor\Codebooks\Exception\UnknownCodebookException;

/**
 * Twig extension na dosazování číselníkových hodnot.
 */
class Codebooks extends \Twig_Extension
{
	/**
	 * Číselníky.
	 *
	 * @var CodebookProvider
	 */
	private $_codebooks;

	/**
	 * Inicializuje objekt.
	 *
	 * @param CodebookProvider $codebook Číselníky.
	 */
	public function __construct(CodebookProvider $codebook)
	{
		$this->_codebooks = $codebook;
	}

	/**
	 * @inheritdoc
	 */
	public function getFunctions()
	{
		return array(
			'codebookValue' => new \Twig_SimpleFunction(
					'codebookValue', array($this, 'getValue')
			),
		);
	}

	public function getValue($codebookName, $value, $locale)
	{
		try {
			$codebook = $this->_codebooks->getCodebook($codebookName, $locale);

			return isset($codebook[$value]) ? $codebook[$value] : null;
		} catch (UnknownCodebookException $e) {
			return null;
		}
	}

	/**
	 * Returns the name of the extension.
	 *
	 * @return string The extension name.
	 */
	public function getName()
	{
		return 'codebooks';
	}
}
