<?php
/**
 * Created by PhpStorm.
 * User: Karel
 * Date: 10.12.13
 * Time: 13:02
 */

namespace Dalten\WebBundle\Test\SeoRoute;

use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\SeoRoute\FragmentCollection;
use Mockery as m;


class FragmentCollectionTest extends \PHPUnit_Framework_TestCase
{
	private $_sampleConfig = array(
		'bagr' => array('advert_type', 'listing_type'), array('kolobezka' => array('advert_type', 'flat_kind'))
	);

	public function testCollectionMatchesFoundUrlFragmentsWithRouteConfig()
	{
		$filter = new ListingFilter(array());
		$firstFindingMatcher = m::mock('Dalten\WebBundle\SeoRoute\Matcher\ListingFilter\BasicFragmentMatcher');
		$nonFindingMatcher = m::mock('Dalten\WebBundle\SeoRoute\Matcher\ListingFilter\BasicFragmentMatcher');
		$secondFindingMatcher = m::mock('Dalten\WebBundle\SeoRoute\Matcher\ListingFilter\BasicFragmentMatcher');
		$firstFindingMatcher->shouldReceive('getRouteParamsForFilter')->with($filter)->once()->andReturn(array('advert_type' => '5'));
		$secondFindingMatcher->shouldReceive('getRouteParamsForFilter')->with($filter)->once()->andReturn(array('listing_type' => '7'));
		$nonFindingMatcher->shouldReceive('getRouteParamsForFilter')->with($filter)->once()->andReturn(null);
		$firstFindingMatcher->shouldReceive('getMatchedFilterParamsForFilter')->with($filter)->once()->andReturn(array('xx'));
		$secondFindingMatcher->shouldReceive('getMatchedFilterParamsForFilter')->with($filter)->once()->andReturn(array('yy'));

		$collection = new FragmentCollection(
			$this->_sampleConfig, array($firstFindingMatcher, $nonFindingMatcher, $secondFindingMatcher)
		);

		$result = $collection->getRouteConfig($filter);
		$this->assertNotNull($result);
		$this->assertArrayHasKey('name', $result);
		$this->assertArrayHasKey('parameters', $result);
		$this->assertEquals('bagr', $result['name']);
		$this->assertEquals(array('advert_type' => '5', 'listing_type' => '7'), $result['parameters']);
	}

	public function testCollectionIgnoresCountryCodeWhileMatching()
	{
		$filter = new ListingFilter(array('locality_country_code' => 'CZ'));
		$firstFindingMatcher = m::mock('Dalten\WebBundle\SeoRoute\Matcher\ListingFilter\BasicFragmentMatcher');
		$nonFindingMatcher = m::mock('Dalten\WebBundle\SeoRoute\Matcher\ListingFilter\BasicFragmentMatcher');
		$secondFindingMatcher = m::mock('Dalten\WebBundle\SeoRoute\Matcher\ListingFilter\BasicFragmentMatcher');
		$firstFindingMatcher->shouldReceive('getRouteParamsForFilter')->with($filter)->once()->andReturn(array('advert_type' => '5'));
		$secondFindingMatcher->shouldReceive('getRouteParamsForFilter')->with($filter)->once()->andReturn(array('listing_type' => '7'));
		$nonFindingMatcher->shouldReceive('getRouteParamsForFilter')->with($filter)->once()->andReturn(null);
		$firstFindingMatcher->shouldReceive('getMatchedFilterParamsForFilter')->with($filter)->once()->andReturn(array('xx'));
		$secondFindingMatcher->shouldReceive('getMatchedFilterParamsForFilter')->with($filter)->once()->andReturn(array('yy'));

		$collection = new FragmentCollection(
			$this->_sampleConfig, array($firstFindingMatcher, $nonFindingMatcher, $secondFindingMatcher)
		);

		$result = $collection->getRouteConfig($filter);
		$this->assertNotNull($result);
		$this->assertArrayHasKey('name', $result);
		$this->assertArrayHasKey('parameters', $result);
		$this->assertEquals('bagr', $result['name']);
		$this->assertEquals(array('advert_type' => '5', 'listing_type' => '7'), $result['parameters']);
	}

	public function testCollectionDoesNotMatchIfMoreThanSpecifiedParamsAreMatched()
	{
		$filter = new ListingFilter(array('advert_type' => 1, 'listing_type' => 4));
		$firstFindingMatcher = m::mock('Dalten\WebBundle\SeoRoute\Matcher\ListingFilter\BasicFragmentMatcher');
		$thirdFindingMatcher = m::mock('Dalten\WebBundle\SeoRoute\Matcher\ListingFilter\BasicFragmentMatcher');
		$secondFindingMatcher = m::mock('Dalten\WebBundle\SeoRoute\Matcher\ListingFilter\BasicFragmentMatcher');
		$firstFindingMatcher->shouldReceive('getRouteParamsForFilter')->with($filter)->once()->andReturn(array('advert_type' => '5'));
		$secondFindingMatcher->shouldReceive('getRouteParamsForFilter')->with($filter)->once()->andReturn(array('listing_type' => '7'));
		$thirdFindingMatcher->shouldReceive('getRouteParamsForFilter')->with($filter)->once()->andReturn(array('flat_kind' => '3'));
		$firstFindingMatcher->shouldReceive('getMatchedFilterParamsForFilter')->with($filter)->once()->andReturn(array('xx'));
		$secondFindingMatcher->shouldReceive('getMatchedFilterParamsForFilter')->with($filter)->once()->andReturn(array('yy'));
		$thirdFindingMatcher->shouldReceive('getMatchedFilterParamsForFilter')->with($filter)->once()->andReturn(array('zz'));

		$collection = new FragmentCollection(
			$this->_sampleConfig, array($firstFindingMatcher, $secondFindingMatcher, $thirdFindingMatcher)
		);

		$this->assertNull($collection->getRouteConfig($filter));
	}

	public function testCollectionDoesNotMatchIfFilterContainsUnmatchedItems()
	{
		$filter = new ListingFilter(array('advert_type' => 1, 'listing_type' => 4, 'flat_kind' => 3));
		$firstFindingMatcher = m::mock('Dalten\WebBundle\SeoRoute\Matcher\ListingFilter\BasicFragmentMatcher');
		$nonFindingMatcher = m::mock('Dalten\WebBundle\SeoRoute\Matcher\ListingFilter\BasicFragmentMatcher');
		$secondFindingMatcher = m::mock('Dalten\WebBundle\SeoRoute\Matcher\ListingFilter\BasicFragmentMatcher');
		$firstFindingMatcher->shouldReceive('getRouteParamsForFilter')->with($filter)->once()->andReturn(array('advert_type' => 'velke'));
		$secondFindingMatcher->shouldReceive('getRouteParamsForFilter')->with($filter)->once()->andReturn(array('listing_type' => 'obrovska'));
		$nonFindingMatcher->shouldReceive('getRouteParamsForFilter')->with($filter)->with($filter)->once()->andReturn(array());
		$firstFindingMatcher->shouldReceive('getMatchedFilterParamsForFilter')->with($filter)->once()->andReturn(array('advert_type'));
		$secondFindingMatcher->shouldReceive('getMatchedFilterParamsForFilter')->with($filter)->once()->andReturn(array('listing_type'));
		$nonFindingMatcher->shouldReceive('getMatchedFilterParamsForFilter')->never()->andReturn(array('flat_kind'));

		$collection = new FragmentCollection(
			$this->_sampleConfig, array($firstFindingMatcher, $secondFindingMatcher, $nonFindingMatcher)
		);

		$this->assertNull($collection->getRouteConfig($filter));
	}
}
