<?php
/**
 * Created by PhpStorm.
 * User: Karel
 * Date: 11.12.13
 * Time: 15:03
 */

namespace Dalten\WebBundle\Test\SeoRoute\Matcher\ListingFilter;


use Dalten\WebBundle\Filter\AddressFilter;
use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\SeoRoute\Matcher\ListingFilter\LocalityFragmentMatcher;
use Mockery as m;

class LocalityFragmentMatcherTest extends \PHPUnit_Framework_TestCase
{
	public function testGetRouteParamsFromFilterReturnsOutputOfInnerGenerator()
	{
		$generator = m::mock('Dalten\WebBundle\Processor\SeoUrl\AddressSlugGenerator');
		$filter = new ListingFilter(array(), array(new AddressFilter(1, array(33))));
		$matcher = new LocalityFragmentMatcher($generator);

		$generator->shouldReceive('getAddressUrlParams')->with($filter)
			->andReturn(array('county' => 'bagr', 'region' => 'kolo'));

		$result = $matcher->getRouteParamsForFilter($filter);

		$this->assertInternalType('array', $result);
		$this->assertCount(2, $result);
		$this->assertArrayHasKey('county', $result);
		$this->assertEquals('bagr', $result['county']);
		$this->assertArrayHasKey('region', $result);
		$this->assertEquals('kolo', $result['region']);
	}
	public function testGetRouteParamsFromFilterCachesResultsForIdenticalFilters()
	{
		$generator = m::mock('Dalten\WebBundle\Processor\SeoUrl\AddressSlugGenerator');
		$filter = new ListingFilter(array(), array(new AddressFilter(1, array(33))));
		$filterWithProps = new ListingFilter(array('advert_type' => array(1)), array(new AddressFilter(1, array(33))));
		$matcher = new LocalityFragmentMatcher($generator);

		$generator->shouldReceive('getAddressUrlParams')->once()->with($filter)
				->andReturn(array('county' => 'bagr', 'region' => 'kolo'));

		$this->assertSame(
				$matcher->getRouteParamsForFilter($filter),
				$matcher->getRouteParamsForFilter($filterWithProps)
		);
	}

	public function testGetMatchedFilterParamsForFilterReturnsKeysFromOutputOfInnerGenerator()
	{
		$generator = m::mock('Dalten\WebBundle\Processor\SeoUrl\AddressSlugGenerator');
		$filter = new ListingFilter(array(), array(new AddressFilter(1, array(33))));
		$matcher = new LocalityFragmentMatcher($generator);

		$generator->shouldReceive('getAddressUrlParams')->with($filter)
			->andReturn(array('county' => 'bagr', 'region' => 'kolo'));

		$result = $matcher->getMatchedFilterParamsForFilter($filter);

		$this->assertInternalType('array', $result);
		$this->assertCount(2, $result);
		$this->assertEquals(array('county', 'region'), $result);
	}

}
