<?php
namespace Dalten\WebBundle\Test\Breadcrumbs\Broker\Collection;

use Dalten\WebBundle\Filter\BrokerFilter;
use Dalten\WebBundle\Entity\Broker;
use Dalten\WebBundle\Breadcrumbs\Breadcrumb;
use Dalten\WebBundle\Breadcrumbs\Broker\Collection\Builder;
use Mockery as m;

class BuilderTest extends \PHPUnit_Framework_TestCase
{
	public function testCollectionBuilderCallsAllPassedInBuildersAndReturnsNotEmptyResultsInCorrectOrderWhenCreatedFromListing()
	{
		$firstBreadcrumb = new Breadcrumb('', '');
		$secondBreadcrumb = new Breadcrumb('', '');

		$Broker = new Broker();

		$builders = array();

		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Broker\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromBroker')->with($Broker)->andReturn($firstBreadcrumb);
		$builders[] = $builder;
		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Broker\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromBroker')->with($Broker)->andReturn(null);
		$builders[] = $builder;
		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Broker\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromBroker')->with($Broker)->andReturn($secondBreadcrumb);
		$builders[] = $builder;

		$collection = new Builder($builders);
		$result = $collection->getBreadcrumbsFromBroker($Broker);

		$this->assertCount(2, $result);
		$this->assertSame($firstBreadcrumb, current($result));
		$this->assertSame($secondBreadcrumb, next($result));
	}

	public function testCollectionBuilderCallsAllPassedInBuildersAndReturnsNotEmptyResultsInCorrectOrderWhenCreatedFromFilter()
	{
		$firstBreadcrumb = new Breadcrumb('', '');
		$secondBreadcrumb = new Breadcrumb('', '');

		$filter = new BrokerFilter(array());

		$builders = array();

		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Broker\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->andReturn($firstBreadcrumb);
		$builders[] = $builder;
		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Broker\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->andReturn(null);
		$builders[] = $builder;
		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Broker\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->andReturn($secondBreadcrumb);
		$builders[] = $builder;

		$collection = new Builder($builders);
		$result = $collection->getBreadcrumbsFromFilter($filter);

		$this->assertCount(2, $result);
		$this->assertSame($firstBreadcrumb, current($result));
		$this->assertSame($secondBreadcrumb, next($result));
	}
}
