<?php
namespace Dalten\WebBundle\Test\Breadcrumbs\Company\Collection;

use Dalten\WebBundle\Filter\CompanyFilter;
use Dalten\WebBundle\Entity\Company;
use Dalten\WebBundle\Breadcrumbs\Breadcrumb;
use Dalten\WebBundle\Breadcrumbs\Company\Collection\Builder;
use Mockery as m;

class BuilderTest extends \PHPUnit_Framework_TestCase
{
	public function testCollectionBuilderCallsAllPassedInBuildersAndReturnsNotEmptyResultsInCorrectOrderWhenCreatedFromListing()
	{
		$firstBreadcrumb = new Breadcrumb('', '');
		$secondBreadcrumb = new Breadcrumb('', '');

		$company = new Company();

		$builders = array();

		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Company\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromCompany')->with($company)->andReturn($firstBreadcrumb);
		$builders[] = $builder;
		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Company\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromCompany')->with($company)->andReturn(null);
		$builders[] = $builder;
		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Company\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromCompany')->with($company)->andReturn($secondBreadcrumb);
		$builders[] = $builder;

		$collection = new Builder($builders);
		$result = $collection->getBreadcrumbsFromCompany($company);

		$this->assertCount(2, $result);
		$this->assertSame($firstBreadcrumb, current($result));
		$this->assertSame($secondBreadcrumb, next($result));
	}

	public function testCollectionBuilderCallsAllPassedInBuildersAndReturnsNotEmptyResultsInCorrectOrderWhenCreatedFromFilter()
	{
		$firstBreadcrumb = new Breadcrumb('', '');
		$secondBreadcrumb = new Breadcrumb('', '');

		$filter = new CompanyFilter(array());

		$builders = array();

		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Company\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->andReturn($firstBreadcrumb);
		$builders[] = $builder;
		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Company\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->andReturn(null);
		$builders[] = $builder;
		$builder = m::mock('Dalten\WebBundle\Breadcrumbs\Company\Builder\StaticRoute');
		$builder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->andReturn($secondBreadcrumb);
		$builders[] = $builder;

		$collection = new Builder($builders);
		$result = $collection->getBreadcrumbsFromFilter($filter);

		$this->assertCount(2, $result);
		$this->assertSame($firstBreadcrumb, current($result));
		$this->assertSame($secondBreadcrumb, next($result));
	}
}
