<?php
namespace Dalten\WebBundle\Test\Breadcrumbs\Listing\Builder;

use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Entity\Listing;
use Dalten\WebBundle\Breadcrumbs\Listing\Builder\StaticRoute;
use Mockery as m;

class StaticRouteTest extends \PHPUnit_Framework_TestCase
{
	public function testCreateBreadcrumbFromFilterReturnsSpecifiedBreadcrumb()
	{
		$config = array(
			'label' => 'bagr',
			'routeName' => 'rypadlo',
			'routeParams' => array('x' => 'y')
		);
		$builder = new StaticRoute($config);
		$breadcrumb = $builder->getBreadcrumbFromFilter(new ListingFilter(array()));

		$this->assertSame($config['label'], $breadcrumb->getLabel());
		$this->assertSame($config['routeName'], $breadcrumb->getRouteName());
		$this->assertSame($config['routeParams'], $breadcrumb->getRouteParams());
	}

	public function testCreateBreadcrumbFromListingReturnsSpecifiedBreadcrumb()
	{
		$config = array(
			'label' => 'bagr',
			'routeName' => 'rypadlo',
			'routeParams' => array('x' => 'y')
		);
		$builder = new StaticRoute($config);
		$listing = new Listing;
		$breadcrumb = $builder->getBreadcrumbFromListing($listing);

		$this->assertSame($config['label'], $breadcrumb->getLabel());
		$this->assertSame($config['routeName'], $breadcrumb->getRouteName());
		$this->assertSame($config['routeParams'], $breadcrumb->getRouteParams());
	}

}
