<?php

namespace Dalten\WebBundle\Tests\Processor\Favourite;


use Dalten\WebBundle\Processor\Favourite\CookieStorage;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;

class CookieStorageTest extends \PHPUnit_Framework_TestCase
{
	public function testGetListingIds()
	{
		$expected = array(1, 2, 3, 4);

		$requset = new Request(array(), array(), array(), array('favourites' => '1,2,3,4,'));
		$response = new Response();

		$adapter = new CookieStorage($requset, $response);

		$this->assertEquals($expected, $adapter->getListingIds());
	}

	public function testAddListings()
	{
		$expected = array(1, 2, 3, 4, 5, 6, 7);

		$requset = new Request(array(), array(), array(), array('favourites' => '1,2,3,4,'));
		$response = new Response();

		$adapter = new CookieStorage($requset, $response);

		$adapter->addListings(array(5, 6, 7, 5));

		$cookies = $response->headers->getCookies();

		/** @var \Symfony\Component\HttpFoundation\Cookie $cookie */
		$cookie = current($cookies);
		$this->assertInstanceOf('Symfony\Component\HttpFoundation\Cookie', $cookie);
		$this->assertEquals('favourites', $cookie->getName());

		$actual = explode(',', rtrim($cookie->getValue(), ','));
		$this->assertEquals($expected, $actual);
	}

	public function testDelListings()
	{
		$expected = array(1, 2, 3, 4);

		$requset = new Request(array(), array(), array(), array('favourites' => '1,2,3,4,5,6,7,'));
		$response = new Response();

		$adapter = new CookieStorage($requset, $response);

		$adapter->delListings(array(5, 6, 7, 5));

		$cookies = $response->headers->getCookies();

		/** @var \Symfony\Component\HttpFoundation\Cookie $cookie */
		$cookie = current($cookies);
		$this->assertInstanceOf('Symfony\Component\HttpFoundation\Cookie', $cookie);
		$this->assertEquals('favourites', $cookie->getName());

		$actual = explode(',', rtrim($cookie->getValue(), ','));
		$this->assertEquals($expected, $actual);
	}
}
 