<?php
/**
 * Created by PhpStorm.
 * User: Karel
 * Date: 6.12.13
 * Time: 11:15
 */

namespace Dalten\Tests\WebBundle\Processor;


use Dalten\WebBundle\Processor\UriParamsToQueryConverter;

class UriParamsToQueryConverterTest extends \PHPUnit_Framework_TestCase
{
	public function testProcessorConvertsSlugsToCorrectMultiDimensionalArrays()
	{
		$config = array(
			'region' => array(
				'bagr' => array('jede' => 'on'),
				'kachna' => array('plave' => 'on')
			),
			'city' => array('ptak' => array('leta' => 'on')),
			'advert_type' => array('tygr' => array('beha' => 'on')),
		);

		$converter = new UriParamsToQueryConverter($config);
		$expected = array('jede' => 'on', 'beha' => 'on');

		$this->assertEquals(
			$expected, $converter->convertParamsToQuery(array('region' => 'bagr', 'advert_type' => 'tygr'))
		);
	}

	public function testProcessorConvertsIgnoresUnknownParams()
	{
		$config = array(
			'region' => array(
				'bagr' => array('jede' => 'on'),
				'kachna' => array('plave' => 'on')
			),
			'city' => array('ptak' => array('leta' => 'on')),
			'advert_type' => array('tygr' => array('beha' => 'on')),
		);

		$converter = new UriParamsToQueryConverter($config);
		$expected = array('jede' => 'on');

		$this->assertEquals(
			$expected, $converter->convertParamsToQuery(array('region' => 'bagr', 'advert_type_bagr' => 'tygr'))
		);
	}

	public function testProcessorConvertsMinAndMaxPrice()
	{
		$converter = new UriParamsToQueryConverter(array());
		$expected = array('price_from' => 15, 'price_to' => 30);

		$this->assertEquals($expected, $converter->convertParamsToQuery(array('price_from' => '15', 'price_to' => 30)));
	}

	public function testProcessorConvertsDiscountDuration()
	{
		$converter = new UriParamsToQueryConverter(array());
		$expected = array('discount_duration' => 7);

		$this->assertEquals($expected, $converter->convertParamsToQuery(array('discount_duration' => '7')));
	}

	public function testProcessorConvertsCompanyId()
	{
		$converter = new UriParamsToQueryConverter(array());
		$expected = array('company_id' => 7);

		$this->assertEquals($expected, $converter->convertParamsToQuery(array('company_id' => '7')));
	}

	public function testProcessorConvertsOnlyProjects()
	{
		$converter = new UriParamsToQueryConverter(array());
		$expected = array('only_projects' => true);

		$this->assertEquals($expected, $converter->convertParamsToQuery(array('only_projects' => 'on')));
	}
}
