<?php

namespace Dalten\WebBundle\Breadcrumbs\Company\Builder;

use Dalten\WebBundle\Filter\CompanyFilter;
use Dalten\WebBundle\Entity\Company;

/**
 * Rozhraní pro tvořiče drobečků.
 */
interface BuilderInterface
{
	/**
	 * Vytvoří drobka z vyplněného modelu firmy.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * @param Company $company Model firmy.
	 *
	 * @return \Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface|null  Drobek nebo null.
	 */
	public function getBreadcrumbFromCompany(Company $company);

	/**
	 * Vytvoří drobka z vyplněného filtru nabídek.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * @param CompanyFilter $filter
	 *
	 * @return \Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface|null  Drobek nebo null.
	 */
	public function getBreadcrumbFromFilter(CompanyFilter $filter);
}
