<?php

namespace Dalten\WebBundle\Breadcrumbs\Company\Builder;

use Dalten\WebBundle\Filter\AddressFilter;
use Dalten\WebBundle\Filter\CompanyFilter;
use Dalten\WebBundle\Entity\Company;
use Dalten\WebBundle\Breadcrumbs\Breadcrumb;
use Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface;
use Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyHelper;

/**
 * Tvořič drobečků na základě předchozího drobečku a kraje.
 */
class OfficeListAndCounty implements BuilderInterface
{
	/**
	 * Helper na vytváření drobků s krajem.
	 *
	 * @var CountyHelper
	 */
	protected $_countyHelper;

	/**
	 * Název vytvářené routy.
	 *
	 * @var string
	 */
	protected $_routeName;

	/**
	 * Parametry vytvářené routy.
	 *
	 * @var array
	 */
	protected $_routeParams;

	/**
	 * Nastavuje konfiguraci.
	 *
	 * @param CountyHelper $countyHelper Helper na vytváření drobků kraje.
	 * @param string       $routeName    Název vytvářené routy.
	 * @param array        $routeParams  Parametry vytvářené routy.
	 */
	public function __construct(CountyHelper $countyHelper, $routeName, $routeParams = array())
	{
		$this->_countyHelper = $countyHelper;
		$this->_routeName = $routeName;
		$this->_routeParams = $routeParams;
	}

	/**
	 * Vytvoří drobka z vyplněného modelu firmy.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * POZOR: Drobek se vytváří pouze z filtru. Dle firmy vrátí vždy null.
	 *
	 * @param Company $company Model firmy.
	 *
	 * @return null Null - drobek se pro modely nevytváří.
	 */
	public function getBreadcrumbFromCompany(Company $company)
	{
		return null;
	}

	/**
	 * Vytvoří drobka z vyplněného filtru firem.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * @param CompanyFilter $filter Vyplněný filtr firem.
	 *
	 * @return BreadcrumbInterface|null Drobek nebo null.
	 */
	public function getBreadcrumbFromFilter(CompanyFilter $filter)
	{
		return $this->_countyHelper->getBreadcrumbFromFilter($filter, $this->_routeName, $this->_routeParams);
	}
}
