<?php
namespace Dalten\WebBundle\Doctrine\Type;

use Doctrine\DBAL\Platforms\AbstractPlatform;
use Doctrine\DBAL\Types\ConversionException;

class DateType extends \Doctrine\DBAL\Types\DateTimeType
{
    public function convertToPHPValue($value, AbstractPlatform $platform)
    {
        if ($value == '0000-00-00' || $value == '0000-00-00 00:00:00') {
            $value = null;
        }
        if ($value === null || $value instanceof \DateTimeInterface) {
            return $value;
        }

        $val = date_create($value);
        if ( ! $val) {
            throw ConversionException::conversionFailedFormat($value, $this->getName(), $platform->getDateFormatString());
        }

        return $val;
    }

    public function getName()
    {
        return 'dalten_date';
    }
}
