<?php
namespace Dalten\WebBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Entita makléře
 *
 * @property int          $id
 * @property int          $company_id
 * @property int          $company_branch_id
 * @property int          $role_id
 * @property string       $email
 * @property string       $phone
 * @property string       $first_name
 * @property string       $last_name
 * @property string       $photo_url
 * @property string       $moto
 * @property DevProject[] $projects
 * @property Listing[]    $listings
 * 
 * @ORM\Table(name="uzivatel")
 * @ORM\MappedSuperclass
 */
class Broker implements EntityWithLegacyData
{
	use LegacyDataMethods;

	/**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="id_pobocka", type="integer", nullable=false)
     */
    private $_id_pobocka;

    /**
     * @var integer
     *
     * @ORM\Column(name="id_firma", type="integer", nullable=false)
     */
    private $_id_firma;

    /**
     * @var integer
     *
     * @ORM\Column(name="id_uroven", type="integer", nullable=false)
     */
    private $_id_uroven;

    /**
     * @var string
     *
     * @ORM\Column(name="email", type="string", length=100, nullable=false)
     */
    private $_email;

    /**
     * @var string
     *
     * @ORM\Column(name="telefon", type="string", length=32, nullable=false)
     */
    private $_telefon;

    /**
     * @var string
     *
     * @ORM\Column(name="uzivatel_os_jmeno", type="string", length=255, nullable=true)
     */
    private $_uzivatel_os_jmeno = '';

    /**
     * @var string
     *
     * @ORM\Column(name="uzivatel_os_prijmeni", type="string", length=255, nullable=true)
     */
    private $_uzivatel_os_prijmeni = '';

    /**
     * @var string
     *
     * @ORM\Column(name="moto", type="string", length=255, nullable=false)
     */
    private $_moto;

    /**
     * @var string
     *
     * @ORM\Column(name="foto", type="string", length=255, nullable=false)
     */
    private $_foto;

    /**
     * @var string
     *
     * @ORM\Column(name="foto_big", type="string", length=255, nullable=true)
     */
    private $_foto_big;

	private static $_map = [
		'company_id' => '_id_firma',
		'company_branch_id' => '_id_pobocka',
		'broker' => 'broker',
		'listings' => 'listings',
		'role_id' => '_id_uroven',
		'email' => '_email',
		'phone' => '_telefon',
		'active' => '_aktivni',
		'first_name' => '_uzivatel_os_jmeno',
		'last_name' => '_uzivatel_os_prijmeni',
		'photo_url' => '_foto',
		'large_photo_url' => '_foto_big',
		'website_text' => '_text_na_web',
		'website_text_en' => '_text_na_web_en',
		'languages' => '_specializace_jazyk',
		'county_code' => '_kraj',
		'region_code' => '_okres',
		'slug' => '_link',
		'listing_type_specialization' => '_specializace_typ_nemovitosti',
		'advert_type_specialization' => '_specializace_typ_zakazky',
		'number_of_stars' => '_pocet_hvezdicek',
		'certification_id' => '_certifikace',
		'academic_degrees_before' => '_vzdelani_pred',
		'academic_degrees_after' => '_vzdelani_za',
		'do_not_display' => '_except',
		'identification_number' => '_ic',
		'contact_address_id' => '_kontaktni_misto',
		'web_url' => '_url_webu',
		'assistant_id' => '_id_asistenta_maklere',
		'seznam_retargeting_id' => '_uzivatel_seznam_retargeting_id',
		'google_analytics_id' => '_uzivatel_google_analytics',
		'broker_of_the_year' => '_makler_roku',
		'web_user_roles' => '_id_uroven_web',
		'moto' => '_moto'
	];
}
