<?php

namespace Dalten\WebBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Entity hodnoty číselníkové proměnné.
 *
 *
 * @property int    $id            Identifikátor proměnné.
 * @property int    $variable_id   Identifikátor proměnné.
 * @property int    $value         Hodnota číselníkové položky.
 * @property int    $order         Pořadí  číselníkové položky.
 * @property bool   $visible       Pořadí číselníkové položky.
 * @property string $label_czech   Český label.
 * @property string $label_english Anglický label.
 * @property string $label_slovak  Slovenský label.
 *
 * @ORM\Table(name="variables_list_values", uniqueConstraints={@ORM\UniqueConstraint(name="value", columns={"value", "lang-czech", "id_list"})})
 * @ORM\MappedSuperclass
 */
class VariableListValue implements EntityWithLegacyData
{
	use LegacyDataMethods;

	/**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var integer
     */
    private $_id_list;

    /**
     * @var integer
     *
     * @ORM\Column(name="value", type="integer", nullable=true)
     */
    private $_value;

    /**
     * @var string
     *
     * @ORM\Column(name="`lang-czech`", type="string", length=50, nullable=false)
     */
    private $_lang_czech = '';

    /**
     * @var string
     *
     * @ORM\Column(name="`lang-english`", type="string", length=50, nullable=true)
     */
    private $_lang_english;

    /**
     * @var string
     *
     * @ORM\Column(name="`lang-slovak`", type="string", length=50, nullable=true)
     */
    private $_lang_slovak;

    /**
     * @var integer
     *
     * @ORM\Column(name="visible", type="integer", nullable=true)
     */
    private $_visible;

    /**
     * @var integer
     *
     * @ORM\Column(name="ord", type="integer", nullable=true)
     */
    private $_ord;

    /**
     * @var string
     *
     * @ORM\Column(name="`lang-russian`", type="string", length=50, nullable=false)
     */
    private $langRussian;

	/**
	 * @var Variable
     * 
     * @ORM\ManyToOne(targetEntity="Variable", inversedBy="listValues")
     * @ORM\JoinColumn(name="id_list", referencedColumnName="id")
	 */
	private $variable;

	private static $_map = array(
		'variable_id' => '_id_list',
		'value' => '_value',
		'label_czech' => '_lang_czech',
		'label_english' => '_lang_english',
		'label_slovak' => '_lang_slovak',
		'visible' => '_visible',
		'order' => '_ord',
	);

	/**
	 * @return Variable
	 */
	public function getVariable()
	{
		return $this->variable;
	}
}

