<?php
namespace Dalten\WebBundle\Translation\Extractor\Symfony;

use Dalten\WebBundle\PhpParser\NodeVisitor\TranslationFinder;
use PhpParser\NodeTraverser;
use PhpParser\Parser;
use Symfony\Component\Finder\Finder;
use Symfony\Component\Translation\Extractor\ExtractorInterface;
use Symfony\Component\Translation\MessageCatalogue;

/**
 * Získává texty na překlad z PHP souborů (volání metod trans a transChoice).
 */
class PhpFileExtractor implements ExtractorInterface
{
	/**
	 * Překladový prefix.
	 *
	 * Dává se před nově zadané nepřeložené texty.
	 *
	 * @var string
	 */
	private $_prefix = '__';

	/**
	 * Php parser.
	 *
	 * @var Parser
	 */
	private $_parser;

	/**
	 * Cesty ke zdrojovým kódům k extrakci.
	 *
	 * @var array
	 */
	private $_sourceCodePaths;

	/**
	 * Nastavuje parser a cesty ke zdrojům.
	 *
	 * @param Parser $parser          Php parser.
	 * @param array  $sourceCodePaths Cesty ke zdrojovým kódům k extrakci.
	 */
	public function __construct(Parser $parser, array $sourceCodePaths)
	{
		$this->_parser = $parser;
		$this->_sourceCodePaths = $sourceCodePaths;
	}

	/**
	 * Extrahuje zprávy k překladu z PHP souborů.
	 *
	 * Argument $directory je ignorován a místo něj se prohledávají cesty z konstruktoru.
	 *
	 * @param string           $directory Adresář, odkud se berou překlad - v tomto případě je ignorován.
	 * @param MessageCatalogue $catalogue Katalog zpráv k překladu.
	 */
	public function extract($directory, MessageCatalogue $catalogue)
	{
		$traverser = new NodeTraverser();
		$visitor = new TranslationFinder();
		$traverser->addVisitor($visitor);

		$finder = Finder::create()->files()->name('*.php')->contains('/trans\(|transChoice\(/');

		foreach ($this->_sourceCodePaths as $path) {
			$finder->in($path);
		}

		foreach ($finder as $file) {
			$traverser->traverse($this->_parser->parse(file_get_contents($file)));
		}

		$visitor->fillCatalogue($catalogue, $this->_prefix);
	}

	/**
	 * Sets the prefix that should be used for new found messages.
	 *
	 * @param string $prefix The prefix.
	 */
	public function setPrefix($prefix)
	{
		$this->_prefix = $prefix;
	}
}
