<?php
namespace Dalten\WebBundle\Twig\Extensions\Extension;

use Dalten\WebBundle\Processor\ListingTitleGenerator;
use Dalten\WebBundle\Entity\Listing;

/**
 * Twig extension na generování titulků nemovitostí.
 */
class ListingTitle extends \Twig_Extension
{
	/**
	 * Generátor titulků.
	 *
	 * @var ListingTitleGenerator
	 */
	private $_generator;

	/**
	 * Nastavuje generátor titulků.
	 *
	 * @param ListingTitleGenerator $generator Instance generátoru titulků.
	 */
	public function __construct(ListingTitleGenerator $generator)
	{
		$this->_generator = $generator;
	}

	/**
	 * @inheritdoc
	 */
	public function getFunctions()
	{
		return array(
			'generateTitle' => new \Twig_SimpleFunction(
					'generateTitle', array($this, 'generateTitle')
			),
		);
	}

	/**
	 * Metoda na vygenerování titulku.
	 *
	 * Pokud se nepovede titulek vygenerovat vrátí prázdný string.
	 *
	 * @param Listing $listing
	 *
	 * @return string
	 */
	public function generateTitle(Listing $listing)
	{
		try {
			return $this->_generator->getTitleForListing($listing);
		} catch (\Exception $e) {
			// Generování selhalo, ale web kvůli tomu shazovat nebudeme.
		}
		return '';
	}

	/**
	 * Returns the name of the extension.
	 *
	 * @return string The extension name.
	 */
	public function getName()
	{
		return 'listingTitle';
	}

}
