<?php
namespace Dalten\WebBundle\Test\Breadcrumbs\Company\Builder;

use Dalten\WebBundle\Filter\CompanyFilter;
use Dalten\WebBundle\Entity\Company;
use Dalten\WebBundle\Breadcrumbs\Company\Builder\StaticRoute;
use Mockery as m;

class StaticRouteTest extends \PHPUnit_Framework_TestCase
{
	public function testCreateBreadcrumbFromFilterReturnsSpecifiedBreadcrumb()
	{
		$config = array(
			'label' => 'bagr',
			'routeName' => 'rypadlo',
			'routeParams' => array('x' => 'y')
		);
		$builder = new StaticRoute($config);
		$breadcrumb = $builder->getBreadcrumbFromFilter(new CompanyFilter(array()));

		$this->assertSame($config['label'], $breadcrumb->getLabel());
		$this->assertSame($config['routeName'], $breadcrumb->getRouteName());
		$this->assertSame($config['routeParams'], $breadcrumb->getRouteParams());
	}

	public function testCreateBreadcrumbFromListingReturnsSpecifiedBreadcrumb()
	{
		$config = array(
			'label' => 'bagr',
			'routeName' => 'rypadlo',
			'routeParams' => array('x' => 'y')
		);
		$builder = new StaticRoute($config);
		$company = new Company();
		$breadcrumb = $builder->getBreadcrumbFromCompany($company);

		$this->assertSame($config['label'], $breadcrumb->getLabel());
		$this->assertSame($config['routeName'], $breadcrumb->getRouteName());
		$this->assertSame($config['routeParams'], $breadcrumb->getRouteParams());
	}

}
