<?php
namespace Dalten\WebBundle\Test\Breadcrumbs\Listing\Builder;

use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Entity\Listing;
use Dalten\WebBundle\Breadcrumbs\Breadcrumb;
use Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingAndAdvertTypeAndPrice;
use Mockery as m;

class ListingAndAdvertTypeAndPriceTest extends \PHPUnit_Framework_TestCase
{
	private $_defaultConfig = array(
		'priceLimitTypes' => array(
			'min' => array(
				'routeName' => 'minRoute',
				'label' => 'Od #minPrice#'
			),
			'max' => array(
				'routeName' => 'maxRoute',
				'label' => 'Do #maxPrice#'
			),
			'both' => array(
				'routeName' => 'rangeRoute',
				'label' => 'Od #minPrice# do #maxPrice#'
			)
		)
	);

	/**
	 * @dataProvider priceRangeProvider
	 */
	public function testCreateBreadcrumbFromFilterReturnsSpecifiedBreadcrumb($minPrice, $maxPrice,
		$expectedLabel, $expectedRouteName, $expectedAddedRouteParams, $errorMessage = null)
	{
		$filter = new ListingFilter(array('price_min' => $minPrice, 'price_max' => $maxPrice));

		$previousBreadcrumb = new Breadcrumb(
			'testik', 'test', array('x' => 'y')
		);

		$previousBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingAndAdvertType');
		$previousBuilder->shouldReceive('getBreadcrumbFromFilter')->with($filter)
			->once()->andReturn($previousBreadcrumb);

		$builder = new ListingAndAdvertTypeAndPrice($previousBuilder, $this->_defaultConfig);
		$breadcrumb = $builder->getBreadcrumbFromFilter($filter);

		$this->assertSame($expectedLabel, $breadcrumb->getLabel(), $errorMessage);
		$this->assertSame($expectedRouteName, $breadcrumb->getRouteName(), $errorMessage);
		$expectedParams = array_merge($previousBreadcrumb->getRouteParams(), $expectedAddedRouteParams);
		$this->assertEquals($expectedParams, $breadcrumb->getRouteParams(), $errorMessage);
	}

	public function testCreateBreadcrumbFromListingReturnsNull()
	{
		$previousBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingAndAdvertType');
		$builder = new ListingAndAdvertTypeAndPrice($previousBuilder, $this->_defaultConfig);
		$listing = new Listing();

		$breadcrumb = $builder->getBreadcrumbFromListing($listing);

		$this->assertNull($breadcrumb);
	}


	public function testCreateBreadcrumbFromFilterReturnsNullIfNoPriceIsSet()
	{
		$filter = new ListingFilter(array('price_min' => 0, 'price_max' => 0));
		$previousBreadcrumb = new Breadcrumb(
			'testik', 'test', array('x' => 'y')
		);

		$previousBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingAndAdvertType');
		$previousBuilder->shouldReceive('getBreadcrumbFromFilter')->with($filter)
			->once()->andReturn($previousBreadcrumb);
		$builder = new ListingAndAdvertTypeAndPrice($previousBuilder, $this->_defaultConfig);
		$breadcrumb = $builder->getBreadcrumbFromFilter($filter);

		$this->assertNull($breadcrumb);
	}



	public function priceRangeProvider()
	{
		return array(
			'min' => array(1, 0, 'Od #minPrice#', 'minRoute', array('price_from' => 1)),
			'max' => array(0, 2, 'Do #maxPrice#', 'maxRoute', array('price_to' => 2)),
			'min+max' => array(
				1, 2, 'Od #minPrice# do #maxPrice#', 'rangeRoute', array('price_from' => 1, 'price_to' => 2)
			),
			'int-conversion' => array(
				1.1, 3.9, 'Od #minPrice# do #maxPrice#', 'rangeRoute', array('price_from' => 1, 'price_to' => 3),
				'Ceny by měly být převedeny z float na int (kvůli routám).'
			),
		);
	}

}
