<?php
namespace Dalten\WebBundle\Test\Breadcrumbs\Listing\Builder;

use Dalten\WebBundle\Filter\AddressFilter;
use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Entity\Listing;
use Dalten\WebBundle\Breadcrumbs\Breadcrumb;
use Dalten\WebBundle\Breadcrumbs\Listing\Builder\PreviousBreadcrumbAndCounty;
use Mockery as m;

class PreviousBreadcrumbAndCountyTest extends \PHPUnit_Framework_TestCase
{
	private $_defaultConfig = array(
		'countyIdToSlugMap' => array(7 => 'bagr', 8 => 'bagrik'),
        'countyIdToLabelMap' => array(7 => 'Bagr', 8 => 'bagrik')
	);


	public function testBuilderUsesFirstSuccesfullyCreatedBreadcrumbFromListing()
	{
		$listing = new Listing();
		$listing->listing_locality_county_code = 7;
		$breadcrumb = new Breadcrumb('x', 'route', array('x' => 'y'));
		$listingTypeBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingType');
		$listingTypeBuilder->shouldReceive('getBreadcrumbFromListing')->never();
		$listingAndAdvertTypeBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingAndAdvertType');
		$listingAndAdvertTypeBuilder->shouldReceive('getBreadcrumbFromListing')->with($listing)->once()->andReturn($breadcrumb);
		$listingAndAdvertTypeAndPriceBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingAndAdvertTypeAndPrice');
		$listingAndAdvertTypeAndPriceBuilder->shouldReceive('getBreadcrumbFromListing')->with($listing)
			->once()->andReturn(null);
		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyHelper');
		$helper->shouldReceive('getBreadcrumb')->with(7, 'route_and_county', array('x' => 'y'))->once()
			->andReturn('success');
		$builder = new PreviousBreadcrumbAndCounty(
			array($listingAndAdvertTypeAndPriceBuilder, $listingAndAdvertTypeBuilder, $listingTypeBuilder),
			$helper,
			$this->_defaultConfig
		);

		$this->assertSame('success', $builder->getBreadcrumbFromListing($listing));
	}

	public function testBuilderRetunsNullIfNoPreviousBreadcrumbWasFound()
	{
		$listing = new Listing();
		$listing->listing_locality_county_code = 7;
		$filter = new ListingFilter(array(), array(new AddressFilter(7, array())));

		$listingAndAdvertTypeAndPriceBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingAndAdvertTypeAndPrice');
		$listingAndAdvertTypeAndPriceBuilder->shouldReceive('getBreadcrumbFromFilter')
			->with($filter)->once()->andReturn(null);
		$listingAndAdvertTypeAndPriceBuilder->shouldReceive('getBreadcrumbFromListing')
			->with($listing)->once()->andReturn(null);
		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyHelper');
		$helper->shouldReceive('getBreadcrumb')->never();
		$builder = new PreviousBreadcrumbAndCounty(
			array($listingAndAdvertTypeAndPriceBuilder), $helper, $this->_defaultConfig
		);

		$this->assertNull($builder->getBreadcrumbFromFilter($filter));
		$this->assertNull($builder->getBreadcrumbFromListing($listing));
	}

	public function testBuilderUsesFirstSuccesfullyCreatedBreadcrumbFromFilter()
	{

		$filter = new ListingFilter(array(), array(new AddressFilter(7, array())));

		$breadcrumb = new Breadcrumb('x', 'route', array('x' => 'y'));
		$listingTypeBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingType');
		$listingTypeBuilder->shouldReceive('getBreadcrumbFromFilter')->never();
		$listingAndAdvertTypeBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingAndAdvertType');
		$listingAndAdvertTypeBuilder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->once()->andReturn($breadcrumb);
		$listingAndAdvertTypeAndPriceBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingAndAdvertTypeAndPrice');
		$listingAndAdvertTypeAndPriceBuilder->shouldReceive('getBreadcrumbFromFilter')->with($filter)
			->once()->andReturn(null);
		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyHelper');
		$helper->shouldReceive('getBreadcrumb')->with(7, 'route_and_county', array('x' => 'y'))->once()
			->andReturn('success');
		$builder = new PreviousBreadcrumbAndCounty(
			array($listingAndAdvertTypeAndPriceBuilder, $listingAndAdvertTypeBuilder, $listingTypeBuilder),
			$helper,
			$this->_defaultConfig
		);

		$this->assertSame('success', $builder->getBreadcrumbFromFilter($filter));
	}

	public function testBuilderCanCreateAllCountiesBreadcrumbFromFilter()
	{
		$filter = new ListingFilter(array(), array(new AddressFilter(7, array()), new AddressFilter(8, array())));

		$breadcrumb = new Breadcrumb('x', 'route', array('x' => 'y'));
		$listingAndAdvertTypeBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingAndAdvertType');
		$listingAndAdvertTypeBuilder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->once()->andReturn($breadcrumb);
		$config = $this->_defaultConfig;
		$config['allCountiesLabel'] = 'celá ČR';
		$config['allCountiesSlug'] = 'ceska-republika';
		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyHelper');
		$helper->shouldReceive('getBreadcrumb')->never();
		$builder = new PreviousBreadcrumbAndCounty(
			array($listingAndAdvertTypeBuilder),
			$helper,
			$config
		);

		$result = $builder->getBreadcrumbFromFilter($filter);

		$this->assertNotNull($result);
		$this->assertSame($breadcrumb->getRouteName().'_and_county', $result->getRouteName());
		$this->assertEquals(
			array_merge($breadcrumb->getRouteParams(), array('county' => 'ceska-republika')), $result->getRouteParams()
		);
		$this->assertSame('celá ČR', $result->getLabel());
	}

	public function testBuilderDoesNotCreateAllCountiesBreadcrumbFromFilterIfAllCountiesSlugAndLabelAreNotSet()
	{
		$filter = new ListingFilter(array(), array(new AddressFilter(7, array()), new AddressFilter(8, array())));

		$breadcrumb = new Breadcrumb('x', 'route', array('x' => 'y'));
		$listingAndAdvertTypeBuilder = m::mock('Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingAndAdvertType');
		$listingAndAdvertTypeBuilder->shouldReceive('getBreadcrumbFromFilter')->with($filter)->once()->andReturn($breadcrumb);
		$config = $this->_defaultConfig;
		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyHelper');
		$helper->shouldReceive('getBreadcrumb')->with(7, 'route_and_county', array('x' => 'y'))->once()
			->andReturn('success');
		$builder = new PreviousBreadcrumbAndCounty(
			array($listingAndAdvertTypeBuilder),
			$helper,
			$config
		);

		$this->assertSame('success', $builder->getBreadcrumbFromFilter($filter));
	}
}
