<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Karel
 * Date: 18.10.13
 * Time: 11:35
 * To change this template use File | Settings | File Templates.
 */

namespace Dalten\Tests\WebBundle\Filter;


use Dalten\WebBundle\Filter\AddressFilter;
use Dalten\WebBundle\Filter\ListingFilter;

class ListingFilterTest extends \PHPUnit_Framework_TestCase
{
	/**
	 * @expectedException Dalten\WebBundle\Filter\Exception\PropertyDoesNotExist
	 */
	public function testOnlySpecifiedPropertiesAreAllowed()
	{
		$filter = new ListingFilter(array('advert_type' => array(1)));

		$filter->nonexistant;
	}

	public function testFilterDiscardsUndefinedProperties()
	{
		$filter = new ListingFilter(array('bagr' => array(1)));

		$this->assertFalse(isset($filter->bagr));
	}

	public function testPropertiesCanBeRetrieved()
	{
		$input = array(
			'advert_type' => array(1),
			'price_min' => 10.5,
			'floor_min' => 7
		);
		$filter = new ListingFilter($input);

		$this->assertSame($input['advert_type'], $filter->advert_type);
		$this->assertSame($input['price_min'], $filter->price_min);
		$this->assertSame($input['floor_min'], $filter->floor_min);
	}

	public function testPropertyConversionToArray()
	{
		$filter = new ListingFilter(array('locality_country_code' => array('CZ')));
		$this->assertSame(array('CZ'), $filter->locality_country_code);
		$filter = new ListingFilter(array('locality_country_code' => 3));
		$this->assertSame(array(3), $filter->locality_country_code);
	}

	public function testPropertyConversionToMultiOption()
	{
		$filter = new ListingFilter(array('advert_type' => '1'));
		$this->assertSame(array(1), $filter->advert_type);
		$filter = new ListingFilter(array('advert_type' => array('3')));
		$this->assertSame(array(3), $filter->advert_type);

		$filter = new ListingFilter(array('advert_type' => array('bagr')));
		$this->assertSame(array(\intval('bagr')), $filter->advert_type);
	}

	public function testPropertyConversionToInt()
	{
		$filter = new ListingFilter(array('floor_min' => 1));
		$this->assertSame(1, $filter->floor_min);
		$filter = new ListingFilter(array('floor_min' => '3'));
		$this->assertSame(3, $filter->floor_min);
	}

	public function testPropertyConversionToFloat()
	{
		$filter = new ListingFilter(array('price_min' => 1.5));
		$this->assertSame(1.5, $filter->price_min);
		$filter = new ListingFilter(array('price_min' => '3.5'));
		$this->assertSame(3.5, $filter->price_min);
	}

	public function testPropertyConversionToString()
	{
		$filter = new ListingFilter(array('locality_text' => 'test'));
		$this->assertSame('test', $filter->locality_text);
		$filter = new ListingFilter(array('locality_text' => 1));
		$this->assertSame('1', $filter->locality_text);
	}

	public function testPropertyConversionToBool()
	{
		$filter = new ListingFilter(array('only_projects' => 'bagr'));
		$this->assertTrue($filter->only_projects);
		$filter = new ListingFilter(array('only_projects' => 0));
		$this->assertFalse($filter->only_projects);
	}

	public function testPropertyConversionToArrayOfIntegers()
	{
		$filter = new ListingFilter(array('company_id' => array('CZ')));
		$this->assertSame(array(0), $filter->company_id);
		$filter = new ListingFilter(array('company_id' => 3));
		$this->assertSame(array(3), $filter->company_id);
		$filter = new ListingFilter(array('company_id' => array(3, '77')));
		$this->assertSame(array(3, 77), $filter->company_id);
	}


	public function testFilterCanAcceptsAndRetrieveAddressFilters()
	{
		$address = new AddressFilter(5, array());
		$filter = new ListingFilter(array(), array($address));
		$this->assertSame(array($address), $filter->getAddressFilters());
	}

	/**
	 * @expectedException \Dalten\WebBundle\Filter\Exception\InvalidAddressFilter
	 */
	public function testFilterThrowsExceptionIfInvalidFiltersArePassedIn()
	{
		$filter = new ListingFilter(array(), array(array()));
	}
}
