<?php

namespace Dalten\WebBundle\Tests\Processor\Codebooks;

use Dalten\WebBundle\Processor\Codebooks\CodebookProvider;
use Mockery as m;

class CodebookProviderTest extends \PHPUnit_Framework_TestCase
{
	public function testGetCodebookFindsVariableInStorageReturnsItsCodebookAndStoresItInCache()
	{
		$cache = m::mock('Doctrine\Common\Cache\Cache');
		$repository = m::mock('Doctrine\ORM\EntityRepository');
		$entity = m::mock('Dalten\WebBundle\Entity\Variable');
		$result = ['a' => 'b'];
		$langs = ['cs' => 'czech'];
		$varName = 'nemovitost_typ';
		$locale = 'cs';

		$provider = new CodebookProvider($repository, $cache, $langs);

		$cache->shouldReceive('contains')->once()->with($varName . '_' . $locale)->andReturn(false);
		$repository->shouldReceive('findOneBy')->once()->with(['_var_name' => $varName])->andReturn($entity);
		$entity->shouldReceive('getCodebook')->once()->with('label_czech')->andReturn($result);
		$cache->shouldReceive('save')->once()->with($varName . '_' . $locale, $result);

		$this->assertSame($result, $provider->getCodebook($varName, $locale));
	}

	public function testGetCodebookReturnsCodebookFromCacheIfItIsPresent()
	{
		$cache = m::mock('Doctrine\Common\Cache\Cache');
		$repository = m::mock('Doctrine\ORM\EntityRepository');
		$result = ['a' => 'b'];
		$langs = ['cs' => 'czech'];
		$varName = 'nemovitost_typ';
		$locale = 'cs';

		$provider = new CodebookProvider($repository, $cache, $langs);

		$cache->shouldReceive('contains')->once()->with($varName . '_' . $locale)->andReturn(true)->ordered();
		$cache->shouldReceive('fetch')->once()->with($varName . '_' . $locale)->andReturn($result)->ordered();

		$this->assertSame($result, $provider->getCodebook($varName, $locale));
	}

	/**
	 * @expectedException \Dalten\WebBundle\Processor\Codebooks\Exception\UnknownCodebookException
	 */
	public function testGetCodebookThrowsExceptionIfCodebookDoesNotExist()
	{
		$cache = m::mock('Doctrine\Common\Cache\Cache');
		$repository = m::mock('Doctrine\ORM\EntityRepository');
		$langs = ['cs' => 'czech'];
		$varName = 'nemovitost_typ';
		$locale = 'cs';

		$provider = new CodebookProvider($repository, $cache, $langs);

		$cache->shouldReceive('contains')->once()->with($varName . '_' . $locale)->andReturn(false);
		$repository->shouldReceive('findOneBy')->once()->with(['_var_name' => $varName])->andReturn(null);

		$provider->getCodebook($varName, $locale);
	}

	/**
	 * @expectedException \Dalten\WebBundle\Processor\Codebooks\Exception\UnknownLanguageException
	 */
	public function testGetCodebookChecksIfLocaleIsAllowed()
	{
		$cache = m::mock('Doctrine\Common\Cache\Cache');
		$repository = m::mock('Doctrine\ORM\EntityRepository');
		$langs = ['cs' => 'czech'];
		$varName = 'nemovitost_typ';
		$locale = 'ru';

		$provider = new CodebookProvider($repository, $cache, $langs);

		$provider->getCodebook($varName, $locale);
	}
}
