<?php
/**
 * Created by PhpStorm.
 * User: Karel
 * Date: 27.1.14
 * Time: 12:00
 */

namespace Dalten\WebBundle\Tests\Processor\TitleGenerator\ListingList;

use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Processor\TitleGenerator\ListingList\Composite;
use Mockery as m;


class CompositeTest extends \PHPUnit_Framework_TestCase
{
	public function testComopositeGeneratorReturnsFirstNonEmptyTitleFromInnerGenerators()
	{
		$filter = new ListingFilter(array());
		$firstGenerator = m::mock('Dalten\WebBundle\Processor\TitleGenerator\ListingList\Base');
		$firstGenerator->shouldReceive('createTitle')->with($filter)->andReturn('');
		$secondGenerator = m::mock('Dalten\WebBundle\Processor\TitleGenerator\ListingList\Base');
		$secondGenerator->shouldReceive('createTitle')->with($filter)->andReturn('ahoj');
		$thirdGenerator = m::mock('Dalten\WebBundle\Processor\TitleGenerator\ListingList\Base');
		$thirdGenerator->shouldReceive('createTitle')->never();

		$generator = new Composite(array($firstGenerator, $secondGenerator, $thirdGenerator));
		$this->assertSame('ahoj', $generator->createTitle($filter));
	}

	public function testCompositeGeneratorReturnsEmptyStringIfNoInnerGeneratorsCreateATitle()
	{
		$filter = new ListingFilter(array());
		$firstGenerator = m::mock('Dalten\WebBundle\Processor\TitleGenerator\ListingList\Base');
		$firstGenerator->shouldReceive('createTitle')->with($filter)->andReturn('');

		$generator = new Composite(array($firstGenerator));
		$this->assertSame('', $generator->createTitle($filter));
	}
}
