<?php

namespace Dalten\WebBundle\Breadcrumbs;

/**
 * Obecný model drobečku.
 */
class Breadcrumb implements BreadcrumbInterface
{
	/**
	 * Název drobečku.
	 *
	 * @var string
	 */
	private $_label;

	/**
	 * Název routy drobečku.
	 *
	 * @var string
	 */
	private $_routeName;

	/**
	 * Parametry routy drobečku.
	 *
	 * @var array
	 */
	private $_routeParams;

	/**
	 * Nastavuje parametry drobečku, které již poté nelze změnit.
	 *
	 * @param string $label       Název drobečku.
	 * @param string $routeName   Název routy na kterou drobeček vede.
	 * @param array  $routeParams Paramery routy.
	 */
	public function __construct($label, $routeName, array $routeParams = array())
	{
		$this->_label = $label;
		$this->_routeName = $routeName;
		$this->_routeParams = $routeParams;
	}

	/**
	 * Vrátí label drobečku.
	 *
	 * @return string
	 */
	public function getLabel()
	{
		return $this->_label;
	}

	/**
	 * Vrátí název routy drobečku.
	 *
	 * @return string
	 */
	public function getRouteName()
	{
		return $this->_routeName;
	}

	/**
	 * Vrátí parametry routy drobečku.
	 *
	 * @return array
	 */
	public function getRouteParams()
	{
		return $this->_routeParams;
	}

	/**
	 * Vrátí název typu drobku.
	 *
	 * @return string Název typu drobku.
	 */
	public function getName()
	{
		return 'Default';
	}
}
