<?php

namespace Dalten\WebBundle\Breadcrumbs\Broker\Builder;

use Dalten\WebBundle\Filter\BrokerFilter;
use Dalten\WebBundle\Entity\Broker;
use Dalten\WebBundle\Breadcrumbs\Breadcrumb;
use Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyAndRegionHelper;

/**
 * Tvořič drobečků na základě předchozího krajového drobečku a regionu.
 */
class BrokerListAndCountyAndRegion implements BuilderInterface
{
	/**
	 * Helper na tvoření drobku s regionem.
	 *
	 * @var array
	 */
	private $_helper;

	/**
	 * Tvořič drobku s krajem.
	 *
	 * @var BrokerListAndCounty
	 */
	private $_countyBreadcrumbBuilder;

	/**
	 * Nastavuje závislosti.
	 *
	 * @param BrokerListAndCounty   $countyBreadcrumbBuilder Tvořič drobku s krajem.
	 * @param CountyAndRegionHelper $helper                  Helper na tvoření drobku s regionem.
	 */
	public function __construct(BrokerListAndCounty $countyBreadcrumbBuilder, CountyAndRegionHelper $helper)
	{
		$this->_helper = $helper;
		$this->_countyBreadcrumbBuilder = $countyBreadcrumbBuilder;
	}

	/**
	 * Vytvoří drobka z vyplněného modelu makléře.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * POZOR: Drobek se vytváří pouze z filtru. Dle makléře vrátí vždy null.
	 *
	 * @param Broker $broker Model makléře.
	 *
	 * @return null Null - drobek se pro modely nevytváří.
	 */
	public function getBreadcrumbFromBroker(Broker $broker)
	{
		return null;
	}

	/**
	 * Vytvoří drobka z vyplněného filtru makléřů.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * @param BrokerFilter $filter Vyplněný filtr.
	 *
	 * @return Breadcrumb|null Drobek nebo null.
	 */
	public function getBreadcrumbFromFilter(BrokerFilter $filter)
	{
		$previousBreadcrumb = $this->_countyBreadcrumbBuilder->getBreadcrumbFromFilter($filter);

		if ($previousBreadcrumb === null) {
			return null;
		}

		return $this->_helper->getBreadcrumbFromFilter($filter, $previousBreadcrumb);
	}
}
