<?php

namespace Dalten\WebBundle\Breadcrumbs\Listing\Builder;

use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Entity\Listing;

/**
 * Rozhraní pro tvořiče drobečků.
 */
interface BuilderInterface
{
	/**
	 * Vytvoří drobka z vyplněného modelu nabídky.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * @abstract
	 *
	 * @param Listing $listing Model nabídky.
	 *
	 * @return \Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface|null  Drobek nebo null.
	 */
	public function getBreadcrumbFromListing(Listing $listing);

	/**
	 * Vytvoří drobka z vyplněného filtru nabídek.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * @abstract
	 *
	 * @param ListingFilter $filter
	 *
	 * @return \Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface|null  Drobek nebo null.
	 */
	public function getBreadcrumbFromFilter(ListingFilter $filter);
}
