<?php
namespace Dalten\WebBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\EnumNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Created by PhpStorm.
 * User: karel
 * Date: 14.04.2016
 * Time: 9:51
 */
class Configuration implements ConfigurationInterface
{
	public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('dalten_web');

        $rootNode->append($this->_createListingSeoRoutesTree());
        $rootNode->append($this->_createListingListTitleGeneratorTree());
        $rootNode->append($this->_createPropertyDisplayProviderTree());
        $rootNode->append($this->_createDefaultEmailConfigTree());
        $rootNode->append($this->_createLocalisationTree());
        $rootNode->append($this->_createBreadcrumbsTree());

        return $treeBuilder;
    }

	private function _createListingSeoRoutesTree()
	{
		$treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('listing_seo_routes');
		$rootNode->canBeEnabled();
		$definitionProto = $rootNode->children()->arrayNode('route_definitions')->useAttributeAsKey('route_name')
			->prototype('array');

		/** @var $definitionProto ArrayNodeDefinition */
		$definitionProto->prototype('scalar');

		/** @var $definitionProto EnumNodeDefinition */
		$definitionProto = $rootNode->children()->arrayNode('locales')->defaultValue(['cs', 'en'])->prototype('enum');
		$definitionProto->values(['cs', 'en']);

		$rootNode->children()->arrayNode('ignored_query_params')->prototype('scalar');

		return $rootNode;
	}

	private function _createLocalisationTree()
	{
		$treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('localisation');
		$rootNode->canBeEnabled();

		/** @var $definitionProto ArrayNodeDefinition */
		$definitionProto = $rootNode->children()->arrayNode('parameter_paths_to_translate')->prototype('array');
		$definitionProto->children()->variableNode('data')->isRequired();
		$definitionProto->children()->arrayNode('paths')->defaultValue([]);

		$definitionProto->children()->arrayNode('paths')->prototype('scalar');

		$rootNode->children()->enumNode('provider')->values(['jms', 'symfony'])->defaultValue('symfony');

		return $rootNode;
	}

	private function _createBreadcrumbsTree()
	{
		$treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('breadcrumbs');
		$rootNode->canBeEnabled();

		return $rootNode;
	}

	private function _createListingListTitleGeneratorTree()
	{
		$treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('listing_list_title_generator');
		$rootNode->canBeEnabled();
		$parent = $rootNode->children()->arrayNode('codebooks')->children();

		$codebookNames = [
			'listing_type_default', 'listing_type_sale', 'listing_type_lease', 'flat_kind', 'estate_kind',
			'hotel_kind_default', 'hotel_kind_sale', 'hotel_kind_lease', 'office_kind_default', 'office_kind_sale',
			'office_kind_lease', 'object_kind'
		];

		foreach ($codebookNames as $codebookName) {
			$parent->arrayNode($codebookName)->useAttributeAsKey('value')->prototype('scalar');
		}

		$rootNode->children()->scalarNode('all_counties_title');
		$definitionProto = $rootNode->children()->arrayNode('special_titles')->prototype('array');
		/** @var $definitionProto ArrayNodeDefinition */
		$definitionProto->children()->arrayNode('requirements')->ignoreExtraKeys(false);
		$definitionProto->children()->arrayNode('title_parts')->ignoreExtraKeys(false);

		$rootNode->children()->arrayNode('other_listing_type_ids')->defaultValue([1, 5, 10, 11])->prototype('scalar');

		return $rootNode;
	}

	private function _createPropertyDisplayProviderTree()
	{
		$treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('property_display_provider');
		$rootNode->canBeEnabled();
		$rootNode->children()->arrayNode('allowed_locales')->useAttributeAsKey('locale')
			->defaultValue(['cs' => 'czech', 'en' => 'english'])->prototype('scalar');
		$rootNode->children()->arrayNode('listing_type_to_area_map')
			->useAttributeAsKey('listing_type')->prototype('scalar');

		$definitionProto = $rootNode->children()->arrayNode('displayed_properties_config')
			->useAttributeAsKey('name')->prototype('array');
		/** @var $definitionProto ArrayNodeDefinition */
		$definitionProto->prototype('scalar');

		return $rootNode;
	}

	private function _createDefaultEmailConfigTree()
	{
		$treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('default_email_config');
		$rootNode->canBeEnabled();

		return $rootNode;
	}
}
