<?php
namespace Dalten\WebBundle\Doctrine\Type;

use Doctrine\DBAL\Platforms\AbstractPlatform;
use Doctrine\DBAL\Types\StringType;

class MultiOptionType extends StringType
{
	public function convertToPHPValue($value, AbstractPlatform $platform)
	{
		return \array_keys(\array_filter(\str_split($value)));
	}

	public function convertToDatabaseValue($value, AbstractPlatform $platform)
	{
		if (empty($value)) {
			$value = '';
		} else {
			$stringValue = \str_repeat(0, \max($value));
			// $stringValue je prazdne, pokud prijde nula, tedy ji nastavime a frcime dal.
			if ($stringValue === '') {
				$value = '0';
			} else {
				foreach ($value as $item) {
					$stringValue[$item] = 1;
				}
				$value = $stringValue;
			}
		}

		return parent::convertToDatabaseValue($value, $platform);
	}

	public function getName()
	{
		return 'multi_option';
	}
}
