<?php

namespace Dalten\WebBundle\Entity;

use Dalten\WebBundle\Entity\Exception\InvalidLocaleException;
use Dalten\WebBundle\Entity\Exception\InvalidPropertyException;
use Doctrine\ORM\Mapping as ORM;
use Dalten\WebBundle\Entity\ListingAttachment;
use FrontBundle\Entity\DevProject;
use FrontBundle\Entity\Broker;

/**
 * Model nabídky.
 *
 * Obstarává správu údajů o nabídce a zpřístupňuje hlavní entitu nabídky.
 *
 * @category Irest
 * @package  Model
 *
 * @property integer             $id                                               Identifikátor nabídky.
 * @property integer             $company_id                                       Id firmy nabídky.
 * @property integer             $company_branch_id                                Id pobočky nabídky.
 * @property integer             $company_team_id                                  Id teamu nabídky.
 * @property integer             $user_id                                          Id vlastníka nabídky.
 * @property \DateTime           $created                                          Datum vytvoření nabídky.
 * @property \DateTime           $edited                                           Datum poslední editace nabídky.
 * @property \DateTime           $advert_auction_date                              Datum konání dražby.
 * @property string              $advert_code                                      Kód inzerátu.
 * @property float               $advert_comission_amount                          Výše provize.
 * @property integer             $advert_comission_percent                         Výše provize v procentech.
 * @property integer             $advert_commercial_collection_residential         Příznak zařazení nabídky.
 * @property integer             $advert_contract_type                             Typ smlouvy.
 * @property string              $advert_internal_number                           Interní číslo zakázky.
 * @property string              $advert_number                                    Číslo inzerátu.
 * @property float               $advert_price                                     Cena.
 * @property bool                $advert_price_charge                              Cena vč. poplatků.
 * @property bool                $advert_price_commission                          Cena vč. provize.
 * @property integer             $advert_price_currency                            Měna.
 * @property bool                $advert_price_hidden                              Je cena skrytá?
 * @property bool                $advert_price_legal_services                      Cena vč. právních služeb.
 * @property bool                $advert_price_negotiation                         Cena k jednání.
 * @property float               $advert_price_normalized                          Normalizovaná cena.
 * @property string              $advert_price_text_note_en                        Poznámka k ceně (anglicky).
 * @property string              $advert_price_text_note                           Poznámka k ceně.
 * @property \DateTime           $advert_price_discount_date                       Datum snížení ceny.
 * @property integer             $advert_price_unit                                Jednotka ceny.
 * @property bool                $advert_price_vat                                 Cena s DPH.
 * @property string              $advert_private_note                              Soukromá poznámka.
 * @property integer             $advert_status                                    Stav zakázky.
 * @property string              $advert_title                                     Název inzerátu.
 * @property string              $advert_title_en                                  Název inzerátu (eng).
 * @property float               $advert_total_amount                              Objem zakázky.
 * @property integer             $advert_type                                      Typ zakázky.
 * @property bool                $advert_use_project_photos                        Mají se použít fotky projektu?
 * @property string              $advert_virtual_tour_url                          Virtuální prohlídka (bez http://).
 * @property array               $advert_acquisition_source                        Zdroj akvizice.
 * @property array               $advert_custom_type                               Vlastní typ nabídky (už. číselník).
 * @property integer             $listing_acceptance_year                          Rok kolaudace.
 * @property float               $listing_annuity                                  Anuita u prodeje.
 * @property integer             $listing_annuity_currency                         Měna anuity.
 * @property integer             $listing_balcony                                  Balkón.
 * @property integer             $listing_balcony_area                             Plocha balkonu.
 * @property float               $listing_basic_deposit                            Kauce.
 * @property integer             $listing_beds                                     Počet lůžek.
 * @property \DateTime           $listing_beginning_date                           Datum zahájení stavby.
 * @property integer             $listing_biggest_area                             Plocha největší.
 * @property integer             $listing_building_area                            Zastavěná plocha.
 * @property integer             $listing_building_condition                       Stav objektu.
 * @property integer             $listing_building_up_area                         Obestavěný prostor.
 * @property integer             $listing_built_year                               Rok výstavby.
 * @property float               $listing_ceiling_height                           Výška stropu.
 * @property integer             $listing_cellar                                   Sklep.
 * @property integer             $listing_cellar_area                              Plocha sklepu.
 * @property float               $listing_charge_amount                            Výše poplatků.
 * @property integer             $listing_charge_currency                          Měna poplatků.
 * @property integer             $listing_commercial_area_equipment                Vybavení komerčních prostor.
 * @property string              $listing_commercial_area_equipment_description    Vybavení komerčních prostor - popis.
 * @property string              $listing_commercial_area_equipment_description_en Vybavení komerčních prostor - popis (ang).
 * @property integer             $listing_commercial_count                         Komerční plochy - počet.
 * @property integer             $listing_commercial_kind                          Druh prostor.
 * @property string              $listing_construction_elements                    Konstrukční prvky.
 * @property string              $listing_description                              Detailní popis inzerátu.
 * @property string              $listing_description_en                           Detailní popis inzerátu (anglicky).
 * @property string              $listing_basic_description                        Detailní popis inzerátu.
 * @property string              $listing_basic_description_en                     Detailní popis inzerátu (anglicky).
 * @property integer             $listing_easy_access                              Bezbariérový byt.
 * @property array               $listing_electricity                              Elektřina.
 * @property integer             $listing_energy_efficiency_rating                 Energetická náročnost budovy.
 * @property float               $listing_energy_performance_summary               Ukazatel energetické náročnosti budovy.
 * @property integer             $listing_energy_performance_certificate           Energetická náročnost budovy dle vyhlášky.
 * @property string              $listing_energy_performance_attachment            Cesta ke scanu štítku.
 * @property array               $listing_engineering_networks                     Inženýrské sítě.
 * @property integer             $listing_equipment                                Vybaveno.
 * @property string              $listing_equipment_description                    Popis vybavení.
 * @property string              $listing_equipment_description_en                 Popis vybavení (ang).
 * @property integer             $listing_estate_area                              Vlastní pozemek.
 * @property array               $listing_estate_building                          Cena stavby na pozemku zahrnuta v ceně.
 * @property integer             $listing_estate_building_type                     Druh stavby.
 * @property integer             $listing_estate_kind                              Druh pozemku.
 * @property integer             $listing_facilities                               Občanská vybavenost.
 * @property \DateTime           $listing_finish_date                              Datum ukončení stavby.
 * @property integer             $listing_flat_count                               Počet bytů.
 * @property integer             $listing_flat_facilities                          Vybavení.
 * @property integer             $listing_flat_kind                                Dispozice bytu (velikost).
 * @property integer             $listing_floor_area                               Celková podlahová plocha.
 * @property integer             $listing_floor_count                              Podlaží.
 * @property integer             $listing_floor_number                             Číslo podlaží v domě.
 * @property integer             $listing_free_flats                               Počet bytů volných.
 * @property integer             $listing_free_offices                             Počet volných kanceláří.
 * @property integer             $listing_front_garden                             Předzahrádka.
 * @property integer             $listing_front_garden_area                        Plocha předzahrádky.
 * @property integer             $listing_furnished                                Zařízený.
 * @property integer             $listing_garage                                   Garáž.
 * @property integer             $listing_garage_area                              Garáž.
 * @property integer             $listing_garden                                   Zahrada.
 * @property integer             $listing_garden_area                              Plocha zahrady.
 * @property integer             $listing_garret                                   Půdní vestavba / nástavba.
 * @property array               $listing_gas                                      Plyn.
 * @property integer             $listing_green_area                               Další zelené plochy.
 * @property array               $listing_gully                                    Kanalizace.
 * @property array               $listing_heating                                  Topení.
 * @property integer             $listing_height                                   Výška.
 * @property integer             $listing_hotel_kind                               Typ zařízení.
 * @property integer             $listing_house_count                              Počet domů.
 * @property integer             $listing_house_type                               Typ domu.
 * @property integer             $listing_length                                   Délka (m).
 * @property integer             $listing_living_area                              Obytná plocha celkem.
 * @property string              $listing_locality_country_code                    Značka státu.
 * @property string              $listing_locality_county                          Kraj.
 * @property integer             $listing_locality_county_code                     UIR kód kraje.
 * @property string              $listing_locality_region                          Okres.
 * @property integer             $listing_locality_region_code                     UIR kód okresu.
 * @property string              $listing_locality_municipality                    Obec.
 * @property integer             $listing_locality_municipality_code               UIR kód obce.
 * @property string              $listing_locality_municipality_part               Část obce.
 * @property integer             $listing_locality_municipality_part_code          UIR kód části obce.
 * @property string              $listing_locality_city_part                       Městská část.
 * @property integer             $listing_locality_city_part_code                  UIR kód městské části.
 * @property string              $listing_locality_prague_district                 Pražský obvod.
 * @property integer             $listing_locality_prague_district_code            UIR kód pražského obvodu.
 * @property integer             $listing_locality_cadastral_area_code             Kód katastrálního území.
 * @property string              $listing_locality_cadastral_area_name             Jméno katastrálního území.
 * @property integer             $listing_locality_cadastral_municipality_code     Kód katastru obce (v Praze městská část).
 * @property integer             $listing_locality_cadastral_district_code         Kód katastru okresu (v Praze městský obvod).
 * @property string              $listing_locality_street                          Ulice.
 * @property integer             $listing_locality_street_code                     UIR kód ulice.
 * @property integer             $listing_locality_object_code                     UIR kód objektu.
 * @property integer             $listing_locality_address_code                    UIR kód adresy.
 * @property string              $listing_locality_co                              Číslo orientační.
 * @property string              $listing_locality_cp                              Číslo popisné.
 * @property string              $listing_locality_description                     Popis lokality.
 * @property integer             $listing_locality_inaccuracy_level                Úroveň znepřesnění adresy.
 * @property string              $listing_locality_latitude                        Zeměpisná šířka.
 * @property string              $listing_locality_longitude                       Zeměpisná délka.
 * @property integer             $listing_loggie                                   Lodžie.
 * @property integer             $listing_loggie_area                              Plocha lodžie.
 * @property array               $listing_networks                                 Ostatní rozvody.
 * @property integer             $listing_nolive_other_area                        Další nebytové prostory.
 * @property string              $listing_nolive_other_description                 Popis ostatních nebytových prostor.
 * @property array               $listing_nonresidential                           Další nebytové prostory.
 * @property integer             $listing_object_kind                              Poloha objektu.
 * @property integer             $listing_object_location                          Umístění objektu.
 * @property integer             $listing_object_name                              Název objektu.
 * @property integer             $listing_object_type                              Typ objektu.
 * @property integer             $listing_office_count                             Počet kanceláří.
 * @property integer             $listing_office_equipment                         Vybavení kanceláří.
 * @property string              $listing_office_equipment_description             Popis vybavení kanceláří.
 * @property integer             $listing_office_kind                              Druh prostor.
 * @property integer             $listing_offices                                  Počet kanceláří.
 * @property integer             $listing_offices_area                             Plocha kanceláří.
 * @property integer             $listing_operating_area                           Provozní plocha.
 * @property array               $listing_other                                    Ostatní.
 * @property integer             $listing_other_area                               Jiné plochy.
 * @property string              $listing_other_area_description                   Jiné plochy (popis).
 * @property string              $listing_other_facilities                         Ostatní vybavenost.
 * @property integer             $listing_parcel_type                              Typ parcely.
 * @property integer             $listing_parcel_numbering_type                    Druh číslování parcely.
 * @property string              $listing_parcel_number                            Číslo parcely.
 * @property string              $listing_parcel_subnumber                         Poddělení parcelního čísla.
 * @property integer             $listing_outer_communication_area                 Plocha vnějších komunikací.
 * @property integer             $listing_ownership                                Vlastnictví.
 * @property integer             $listing_parking_place_count                      Počet parkovacích míst.
 * @property bool                $listing_personal                                 Možnost převedení do osobního vlastnictví.
 * @property integer             $listing_plot_area                                Plocha parcely.
 * @property integer             $listing_pool                                     Bazén.
 * @property integer             $listing_pool_area                                Plocha bazénu.
 * @property integer             $listing_production_area                          Výrobní plocha.
 * @property array               $listing_protection                               Umístění v chráněných lokalitách.
 * @property string              $listing_ready_date                               K nastěhování.
 * @property integer             $listing_reconstruction_year                      Rok rekonstrukce.
 * @property integer             $listing_rent_building_type                       Druh bytu.
 * @property integer             $listing_road_type                                Komunikace.
 * @property integer             $listing_seats                                    Počet míst.
 * @property integer             $listing_shops                                    Počet obchodů.
 * @property integer             $listing_shops_area                               Plocha obchodů.
 * @property integer             $listing_smallest_area                            Plocha nejmenší.
 * @property integer             $listing_social                                   Sociální zařízení.
 * @property string              $listing_social_description                       Popis sociálního zařízení.
 * @property integer             $listing_sold_by_parts                            Způsob prodeje.
 * @property array               $listing_stairs                                   Schodiště.
 * @property integer             $listing_store_area                               Plocha skladů.
 * @property integer             $listing_surroundings_type                        Charakter okolní zástavby.
 * @property array               $listing_telecomunication                         Telekomunikace.
 * @property integer             $listing_terrace                                  Terasa.
 * @property integer             $listing_terrace_area                             Plocha terasy.
 * @property integer             $listing_total_area                               Celková plocha.
 * @property array               $listing_transport                                Dopravní dostupnost.
 * @property integer             $listing_trees                                    Stromy.
 * @property integer             $listing_type                                     Typ nemovitosti.
 * @property integer             $listing_underground_floors                       Počet podzemních podlaží.
 * @property integer             $listing_usable_area                              Užitná plocha.
 * @property integer             $listing_usable_area_attic                        Užitná plocha v podkroví.
 * @property integer             $listing_usable_area_ground                       Užitná plocha v přízemí.
 * @property array               $listing_water                                    Voda.
 * @property integer             $listing_width                                    Šířka.
 * @property integer             $listing_workshop_area                            Dílna.
 * @property integer             $listing_workshop_premise_area                    Dílny a provozovny.
 * @property integer             $listing_main_area                                Hlavní plocha nemovitosti.
 * @property integer             $listing_subtype                                  Podtyp nemovitosti.
 * @property integer             $project_id                                       Id projektu.
 * @property integer             $project_group_id                                 Podtyp nemovitosti.
 * @property string              $project_developer_internal_number                Podtyp nemovitosti.
 * @property string              $thumbnail_url                                    Adresa náhledu hlavního obrázku nabídky.
 * @property boolean             $has_open_day                                     Má nabídka den otevřených dveří? (Open house)
 * @property integer             $listing_elevator                                 Výtah (yesnomaybe).
 * @property integer             $listing_room_count                               Počet pokojů.
 * @property \DateTime           $open_day                                         Datum a čas dnu otevřených dveří.
 * @property \DateTime           $open_day_to                                      Datum a čas konce dnu otevřených dveří.
 * @property ListingAttachment[] $attachments                                      Přílohy.
 * @property DevProject          $project                                          Dev. projekt k nabídce.
 * @property Broker              $broker                                           Makléř nabídky.
 *
 * @ORM\Table(name="nabidka", indexes={@ORM\Index(name="nemovitost_titulek", columns={"nemovitost_titulek"})})
 * @ORM\MappedSuperclass
 */
class Listing implements EntityWithLegacyData
{
    use LegacyDataMethods;

    /**
     * @var ListingAttachment[]
     *
     * @ORM\OneToMany(targetEntity="Dalten\WebBundle\Entity\ListingAttachment", mappedBy="listing", fetch="EAGER")
     */
    protected $attachments = [];

    /**
     * @var DevProject
     *
     * @ORM\ManyToOne(targetEntity="FrontBundle\Entity\DevProject", inversedBy="listings")
     * @ORM\JoinColumn(name="id_projekt")
     */
    protected $project;

    /**
     * @var Broker
     *
     * @ORM\OneToOne(targetEntity="FrontBundle\Entity\Broker",fetch="EAGER")
     * @ORM\JoinColumn(name="id_uzivatel")
     */
    protected $broker;

	/**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="id_uzivatel", type="integer", nullable=false)
     */
    private $_id_uzivatel;

    /**
     * @var integer
     *
     * @ORM\Column(name="id_firma", type="integer", nullable=false)
     */
    private $_id_firma;

    /**
     * @var integer
     *
     * @ORM\Column(name="id_pobocka", type="integer", nullable=false)
     */
    private $_id_pobocka;

    /**
    * @var integer
    *
    * @ORM\Column(name="id_projekt", type="integer", nullable=false)
    */
    private $_id_projekt;

    /**
     * @var integer
     *
     * @ORM\Column(name="id_projekt_skupina", type="integer", nullable=false)
     */
    private $_id_projekt_skupina;

    /**
     * @var integer
     *
     * @ORM\Column(name="cislo", type="integer", nullable=false)
     */
    private $_cislo;

    /**
     * @var string
     *
     * @ORM\Column(name="kod", type="string", length=16, nullable=true)
     */
    private $_kod;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_anuita", type="integer", nullable=true)
     */
    private $_nemovitost_anuita;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_anuita_mena", type="integer", nullable=true)
     */
    private $_nemovitost_anuita_mena;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_balkon_plocha", type="integer", nullable=true)
     */
    private $_nemovitost_balkon_plocha;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_balkon", type="integer", nullable=true)
     */
    private $_nemovitost_balkon;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_bazen_plocha", type="integer", nullable=true)
     */
    private $_nemovitost_bazen_plocha;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_bazen", type="integer", nullable=true)
     */
    private $_nemovitost_bazen;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_bezbarierovy", type="integer", nullable=true)
     */
    private $_nemovitost_bezbarierovy;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_bytu_celkem", type="integer", nullable=true)
     */
    private $_nemovitost_bytu_celkem;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_bytu_pocet", type="integer", nullable=true)
     */
    private $_nemovitost_bytu_pocet;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_cena_poznamka", type="string", length=255, nullable=true)
     */
    private $_nemovitost_cena_poznamka = '';

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_cena_poznamka_en", type="string", length=255, nullable=true)
     */
    private $_nemovitost_cena_poznamka_en;

    /**
     * @var float
     *
     * @ORM\Column(name="nemovitost_cena_prodej", type="float", precision=10, scale=0, nullable=true)
     */
    private $_nemovitost_cena_prodej;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_cena_prodej_jednotka", type="integer", nullable=true)
     */
    private $_nemovitost_cena_prodej_jednotka;

    /**
     * @var float
     *
     * @ORM\Column(name="nemovitost_cena_pronajem", type="float", precision=10, scale=0, nullable=true)
     */
    private $_nemovitost_cena_pronajem;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_cena_pronajem_jednotka", type="integer", nullable=true)
     */
    private $_nemovitost_cena_pronajem_jednotka;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_charakter_zastavby", type="integer", nullable=true)
     */
    private $_nemovitost_charakter_zastavby;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_dalsi_nebytove_prostory", type="string", length=255, nullable=true)
     */
    private $_nemovitost_dalsi_nebytove_prostory = '';

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="nemovitost_datum_nastehovani", type="dalten_date", nullable=true)
     */
    private $_nemovitost_datum_nastehovani;

    /**
     * @var float
     *
     * @ORM\Column(name="nemovitost_delka", type="float", precision=10, scale=0, nullable=true)
     */
    private $_nemovitost_delka;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_dispozice", type="integer", nullable=true)
     */
    private $_nemovitost_dispozice;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_doprava", type="string", length=255, nullable=true)
     */
    private $_nemovitost_doprava = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_druh_bytu", type="integer", nullable=true)
     */
    private $_nemovitost_druh_bytu;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_druh_objektu", type="integer", nullable=true)
     */
    private $_nemovitost_druh_objektu;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_druh_pozemku", type="integer", nullable=true)
     */
    private $_nemovitost_druh_pozemku;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_druh_prostor", type="integer", nullable=true)
     */
    private $_nemovitost_druh_prostor;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_druh_stavby", type="integer", nullable=true)
     */
    private $_nemovitost_druh_stavby;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_elektrina", type="string", length=255, nullable=true)
     */
    private $_nemovitost_elektrina = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_garaz_plocha", type="integer", nullable=true)
     */
    private $_nemovitost_garaz_plocha;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_garaz", type="integer", nullable=true)
     */
    private $_nemovitost_garaz;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_inzenyrske_site", type="string", length=255, nullable=true)
     */
    private $_nemovitost_inzenyrske_site = '';

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_konstrukcni_prvky", type="text", length=65535, nullable=true)
     */
    private $_nemovitost_konstrukcni_prvky;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_lodzie_plocha", type="integer", nullable=true)
     */
    private $_nemovitost_lodzie_plocha;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_lodzie", type="integer", nullable=true)
     */
    private $_nemovitost_lodzie;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_makler_poznamka", type="string", length=255, nullable=true)
     */
    private $_nemovitost_makler_poznamka = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_mena", type="integer", nullable=true)
     */
    private $_nemovitost_mena;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_obcanska_vybavenost", type="string", length=255, nullable=true)
     */
    private $_nemovitost_obcanska_vybavenost = '';

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_odpad", type="string", length=255, nullable=true)
     */
    private $_nemovitost_odpad = '';

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_ostatni", type="string", length=255, nullable=true)
     */
    private $_nemovitost_ostatni = '';

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_ostatni_nebytove_prosotry_popis", type="text", length=65535, nullable=true)
     */
    private $_nemovitost_ostatni_nebytove_prosotry_popis;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_ostatni_rozvody", type="string", length=255, nullable=true)
     */
    private $_nemovitost_ostatni_rozvody = '';

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_ostatni_vybavenost", type="text", length=65535, nullable=true)
     */
    private $_nemovitost_ostatni_vybavenost;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_celkova", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_celkova;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_dalsi_nebytove_prostory", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_dalsi_nebytove_prostory;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_dalsi_zelene", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_dalsi_zelene;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_dilna", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_dilna;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_dilny", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_dilny;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_jine", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_jine;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_plocha_jine_popis", type="text", length=65535, nullable=true)
     */
    private $_nemovitost_plocha_jine_popis;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_kancelari", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_kancelari;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_nebytovych_prostor", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_nebytovych_prostor;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_nejmensi", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_nejmensi;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_nejvetsi", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_nejvetsi;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_obchodni", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_obchodni;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_obchodu", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_obchodu;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_obestavena", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_obestavena;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_parcely", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_parcely;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_provozni", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_provozni;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_skladu", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_skladu;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_terasa", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_terasa;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_uzitna", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_uzitna;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_uzitna_podkrovi", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_uzitna_podkrovi;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_uzitna_prizemi", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_uzitna_prizemi;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_vnejsich_komunikaci", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_vnejsich_komunikaci;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_vyrobni", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_vyrobni;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_zahrada", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_zahrada;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_plocha_zastavena", type="integer", nullable=true)
     */
    private $_nemovitost_plocha_zastavena;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_plochy_jine_popis", type="text", length=65535, nullable=true)
     */
    private $_nemovitost_plochy_jine_popis;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_plyn", type="string", length=255, nullable=true)
     */
    private $_nemovitost_plyn = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_pocet_bytu_volnych", type="integer", nullable=true)
     */
    private $_nemovitost_pocet_bytu_volnych;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_pocet_kancelari", type="integer", nullable=true)
     */
    private $_nemovitost_pocet_kancelari;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_pocet_luzek", type="integer", nullable=true)
     */
    private $_nemovitost_pocet_luzek;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_pocet_mist", type="integer", nullable=true)
     */
    private $_nemovitost_pocet_mist;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_pocet_obchodu", type="integer", nullable=true)
     */
    private $_nemovitost_pocet_obchodu;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_pocet_podlazi", type="integer", nullable=true)
     */
    private $_nemovitost_pocet_podlazi;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_pocet_podlazi_pod_zemi", type="integer", nullable=true)
     */
    private $_nemovitost_pocet_podlazi_pod_zemi;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_pocet_volnych_kancelari", type="integer", nullable=true)
     */
    private $_nemovitost_pocet_volnych_kancelari;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_pocet_pokoju", type="integer", nullable=true)
     */
    private $_nemovitost_pocet_pokoju;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_podlazi_cislo", type="integer", nullable=true)
     */
    private $_nemovitost_podlazi_cislo;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_poloha_objektu", type="integer", nullable=true)
     */
    private $_nemovitost_poloha_objektu;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_popis_detailni", type="text", length=65535, nullable=true)
     */
    private $_nemovitost_popis_detailni;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_popis_detailni_en", type="text", length=65535, nullable=true)
     */
    private $_nemovitost_popis_detailni_en;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_popis_zakladni", type="string", length=255, nullable=true)
     */
    private $_nemovitost_popis_zakladni = '';

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_popis_zakladni_en", type="string", length=255, nullable=true)
     */
    private $_nemovitost_popis_zakladni_en;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_prodej_vcelku", type="integer", nullable=true)
     */
    private $_nemovitost_prodej_vcelku;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_pudni_vestavba", type="integer", nullable=true)
     */
    private $_nemovitost_pudni_vestavba;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_rok_kolaudace", type="integer", nullable=true)
     */
    private $_nemovitost_rok_kolaudace;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_rok_rekonstrukce", type="integer", nullable=true)
     */
    private $_nemovitost_rok_rekonstrukce;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_rok_vystavby", type="integer", nullable=true)
     */
    private $_nemovitost_rok_vystavby;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_schodiste", type="string", length=255, nullable=true)
     */
    private $_nemovitost_schodiste = '';

    /**
     * @var float
     *
     * @ORM\Column(name="nemovitost_sirka", type="float", precision=10, scale=0, nullable=true)
     */
    private $_nemovitost_sirka;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_sklep_plocha", type="integer", nullable=true)
     */
    private $_nemovitost_sklep_plocha;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_sklep", type="integer", nullable=true)
     */
    private $_nemovitost_sklep;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_socialni_zarizeni", type="integer", nullable=true)
     */
    private $_nemovitost_socialni_zarizeni;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_socialni_zarizeni_popis", type="text", length=65535, nullable=true)
     */
    private $_nemovitost_socialni_zarizeni_popis;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_stavba_na_pozemku", type="string", length=255, nullable=true)
     */
    private $_nemovitost_stavba_na_pozemku = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_stav_objektu", type="integer", nullable=true)
     */
    private $_nemovitost_stav_objektu;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_stromy", type="integer", nullable=true)
     */
    private $_nemovitost_stromy;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_telekomunikace", type="string", length=255, nullable=true)
     */
    private $_nemovitost_telekomunikace = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_terasa_plocha", type="integer", nullable=true)
     */
    private $_nemovitost_terasa_plocha;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_terasa", type="integer", nullable=true)
     */
    private $_nemovitost_terasa;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_titulek", type="string", length=255, nullable=true)
     */
    private $_nemovitost_titulek = '';

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_titulek_en", type="string", length=255, nullable=true)
     */
    private $_nemovitost_titulek_en;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_topeni", type="string", length=255, nullable=true)
     */
    private $_nemovitost_topeni = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_typ", type="integer", nullable=true)
     */
    private $_nemovitost_typ;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_typ_domu", type="integer", nullable=true)
     */
    private $_nemovitost_typ_domu;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_typ_zarizeni", type="integer", nullable=true)
     */
    private $_nemovitost_typ_zarizeni;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_ucel_budovy", type="integer", nullable=true)
     */
    private $_nemovitost_ucel_budovy;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_umisteni_objektu", type="integer", nullable=true)
     */
    private $_nemovitost_umisteni_objektu;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_umisteni_v_chranenych_lokalitach", type="string", length=255, nullable=true)
     */
    private $_nemovitost_umisteni_v_chranenych_lokalitach = '';

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_velikost_bytu", type="text", length=65535, nullable=true)
     */
    private $_nemovitost_velikost_bytu;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_vlastnictvi", type="integer", nullable=true)
     */
    private $_nemovitost_vlastnictvi;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_vlastni_pozemek", type="integer", nullable=true)
     */
    private $_nemovitost_vlastni_pozemek;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_voda", type="string", length=255, nullable=true)
     */
    private $_nemovitost_voda = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_vybaveni_byt", type="integer", nullable=true)
     */
    private $_nemovitost_vybaveni_byt;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_vybaveni_kancelari", type="integer", nullable=true)
     */
    private $_nemovitost_vybaveni_kancelari;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_vybaveni_kancelari_popis", type="text", length=65535, nullable=true)
     */
    private $_nemovitost_vybaveni_kancelari_popis;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_vybaveni_komercnich_prostor", type="integer", nullable=true)
     */
    private $_nemovitost_vybaveni_komercnich_prostor;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_vybaveni_komercnich_prostor_popis", type="text", length=65535, nullable=true)
     */
    private $_nemovitost_vybaveni_komercnich_prostor_popis;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_vybaveni_komercnich_prostor_popis_en", type="text", length=65535, nullable=true)
     */
    private $_nemovitost_vybaveni_komercnich_prostor_popis_en;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_vybaveno", type="integer", nullable=true)
     */
    private $_nemovitost_vybaveno;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_vybaveno_popis", type="text", length=65535, nullable=true)
     */
    private $_nemovitost_vybaveno_popis;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_vybaveno_popis_en", type="text", length=65535, nullable=true)
     */
    private $_nemovitost_vybaveno_popis_en;

    /**
     * @var float
     *
     * @ORM\Column(name="nemovitost_vyska", type="float", precision=10, scale=0, nullable=true)
     */
    private $_nemovitost_vyska;

    /**
     * @var float
     *
     * @ORM\Column(name="nemovitost_vyska_stropu", type="float", precision=10, scale=0, nullable=true)
     */
    private $_nemovitost_vyska_stropu;

    /**
     * @var integer
     *
     * @ORM\Column(name="pocet_mist_k_parkovani", type="integer", nullable=true)
     */
    private $_pocet_mist_k_parkovani;

    /**
     * @var integer
     *
     * @ORM\Column(name="podlazi", type="integer", nullable=true)
     */
    private $_podlazi;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="zakazka_datum_editace", type="dalten_date", nullable=true)
     */
    private $_zakazka_datum_editace;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="zakazka_datum_vlozeno", type="dalten_date", nullable=true)
     */
    private $_zakazka_datum_vlozeno;

    /**
     * @var integer
     *
     * @ORM\Column(name="zakazka_makler", type="integer", nullable=true)
     */
    private $_zakazka_makler;

    /**
     * @var integer
     *
     * @ORM\Column(name="zakazka_makler_upravil", type="integer", nullable=true)
     */
    private $_zakazka_makler_upravil;

    /**
     * @var integer
     *
     * @ORM\Column(name="zakazka_stav", type="integer", nullable=true)
     */
    private $_zakazka_stav;

    /**
     * @var integer
     *
     * @ORM\Column(name="zakazka_typ", type="integer", nullable=true)
     */
    private $_zakazka_typ;

    /**
     * @var integer
     *
     * @ORM\Column(name="zakazka_obchodovat", type="integer", nullable=true)
     */
    private $_zakazka_obchodovat;

    /**
     * @var float
     *
     * @ORM\Column(name="zakazka_obchodovat_provize_castka", type="float", precision=10, scale=0, nullable=true)
     */
    private $_zakazka_obchodovat_provize_castka;

    /**
     * @var float
     *
     * @ORM\Column(name="zakazka_obchodovat_provize_procenta", type="float", precision=10, scale=0, nullable=true)
     */
    private $_zakazka_obchodovat_provize_procenta;

    /**
     * @var float
     *
     * @ORM\Column(name="zakazka_provize_celkem", type="float", precision=10, scale=0, nullable=true)
     */
    private $_zakazka_provize_celkem;

    /**
     * @var float
     *
     * @ORM\Column(name="zakazka_provize_procenta", type="float", precision=10, scale=0, nullable=true)
     */
    private $_zakazka_provize_procenta;

    /**
     * @var integer
     *
     * @ORM\Column(name="zakazka_provize_typ", type="integer", nullable=true)
     */
    private $_zakazka_provize_typ;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_uir_cobce_kod", type="integer", nullable=true)
     */
    private $_nemovitost_uir_cobce_kod;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_uir_cobce_text", type="string", length=255, nullable=true)
     */
    private $_nemovitost_uir_cobce_text = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_uir_kraj_kod", type="integer", nullable=true)
     */
    private $_nemovitost_uir_kraj_kod;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_uir_kraj_text", type="string", length=255, nullable=true)
     */
    private $_nemovitost_uir_kraj_text = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_uir_mcast_kod", type="integer", nullable=true)
     */
    private $_nemovitost_uir_mcast_kod;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_uir_mcast_text", type="string", length=255, nullable=true)
     */
    private $_nemovitost_uir_mcast_text = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_uir_obec_kod", type="integer", nullable=true)
     */
    private $_nemovitost_uir_obec_kod;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_uir_obec_text", type="string", length=255, nullable=true)
     */
    private $_nemovitost_uir_obec_text = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_uir_okres_kod", type="integer", nullable=true)
     */
    private $_nemovitost_uir_okres_kod;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_uir_okres_text", type="string", length=255, nullable=true)
     */
    private $_nemovitost_uir_okres_text = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_uir_pobvod_kod", type="integer", nullable=true)
     */
    private $_nemovitost_uir_pobvod_kod;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_uir_pobvod_text", type="string", length=255, nullable=true)
     */
    private $_nemovitost_uir_pobvod_text = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_uir_ulice_kod", type="integer", nullable=true)
     */
    private $_nemovitost_uir_ulice_kod;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_uir_ulice_text", type="string", length=255, nullable=true)
     */
    private $_nemovitost_uir_ulice_text = '';

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_uir_cp", type="string", length=10, nullable=false)
     */
    private $_nemovitost_uir_cp;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_uir_co", type="string", length=10, nullable=false)
     */
    private $_nemovitost_uir_co;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_objekt", type="string", length=255, nullable=true)
     */
    private $_nemovitost_objekt = '';

    /**
     * @var string
     *
     * @ORM\Column(name="zakazka_interni_cislo_developera", type="string", length=255, nullable=true)
     */
    private $_zakazka_interni_cislo_developera = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="zakazka_pouzit_foto_projektu", type="integer", nullable=true)
     */
    private $_zakazka_pouzit_foto_projektu;

    /**
     * @var integer
     *
     * @ORM\Column(name="zakazka_typ_smlouvy", type="integer", nullable=true)
     */
    private $_zakazka_typ_smlouvy;

    /**
     * @var string
     *
     * @ORM\Column(name="zakazka_neverejna_poznamka", type="text", length=65535, nullable=true)
     */
    private $_zakazka_neverejna_poznamka;

    /**
     * @var string
     *
     * @ORM\Column(name="nabidka_typ_nabidky", type="string", length=30, nullable=false)
     */
    private $_nabidka_typ_nabidky = '200';

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_energeticky_stitek_priloha", type="string", length=255, nullable=true)
     */
    private $_nemovitost_energeticky_stitek_priloha;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_energeticky_stitek", type="integer", nullable=true)
     */
    private $_nemovitost_energeticky_stitek;

    /**
     * @var float
     *
     * @ORM\Column(name="nemovitost_merna_rocni_spotreba", type="float", precision=10, scale=0, nullable=true)
     */
    private $_nemovitost_merna_rocni_spotreba;

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_energeticky_stitek_vyhlaska", type="integer", nullable=true)
     */
    private $_nemovitost_energeticky_stitek_vyhlaska;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_uir_stat", type="string", length=2, nullable=false)
     */
    private $_nemovitost_uir_stat = 'CZ';

    /**
     * @var integer
     *
     * @ORM\Column(name="nemovitost_vytah", type="integer", nullable=true)
     */
    private $_nemovitost_vytah;

    /**
     * @var string
     *
     * @ORM\Column(name="nabidka_gps_x", type="string", length=100, nullable=true)
     */
    private $_nabidka_gps_x;

    /**
     * @var string
     *
     * @ORM\Column(name="nabidka_gps_y", type="string", length=100, nullable=true)
     */
    private $_nabidka_gps_y;

    /**
     * @var string
     *
     * @ORM\Column(name="nemovitost_virtualni_prohlidka", type="string", length=200, nullable=true)
     */
    private $_nemovitost_virtualni_prohlidka;

	/**
	 * Typ zakázky = pronájem.
	 */
	const ADVERT_LEASE = 2;
	/**
	 * Typ zakázky = prodej.
	 */
	const ADVERT_SELL = 1;

	/**
	 * Příznak aktivní zakázky.
	 */
	const ADVERT_STATUS_ACTIVE = 20;

	/**
	 * Příznak rezervované zakázky.
	 */
	CONST ADVERT_STATUS_RESERVED = 30;

	/**
	 * Příznak prodané nebo pronajaté.
	 */
	CONST ADVERT_STATUS_SOLD_OR_LEASED = 40;

	/**
	 * Mapa typů nemovitostí na názvy vlastností entity s jejich podtypy.
	 *
	 * @var array
	 */
	public static $subTypeMappings = array(
		2 => 'listing_commercial_kind',
		3 => 'listing_estate_kind',
		4 => 'listing_flat_kind',
		5 => 'listing_object_type',
		6 => 'listing_object_kind',
		7 => 'listing_hotel_kind',
		9 => 'listing_office_kind',
		10 => 'listing_object_kind',
		11 => 'listing_object_kind'
	);

	/**
	 * Mapa typů nemovitostí na názvy vlastností entity s jejich podtypy.
	 *
	 * @var array
	 */
	public static $legacySubTypeMappings = array(
		2 => 'nemovitost_ucel_budovy',
		3 => 'nemovitost_druh_pozemku',
		4 => 'nemovitost_dispozice',
		5 => 'nemovitost_druh_objektu',
		6 => 'nemovitost_poloha_objektu',
		7 => 'nemovitost_typ_zarizeni',
		9 => 'nemovitost_druh_prostor',
		10 => 'nemovitost_poloha_objektu',
		11 => 'nemovitost_poloha_objektu'
	);

	/**
	 * Mapa typů nemovitostí na názvy vlastností entity s jejich hlavní plochou.
	 *
	 * @var array
	 */
	public static $areaMappings = array(
		1 => 'listing_usable_area',
		2 => 'listing_total_area',
		3 => 'listing_total_area',
		4 => 'listing_total_area',
		5 => 'listing_usable_area',
		6 => 'listing_usable_area',
		7 => 'listing_usable_area',
		8 => 'listing_usable_area',
		9 => 'listing_offices_area',
		10 => 'listing_building_area',
		11 => 'listing_building_area'
	);

	private static $_map = array(
		'broker' => 'broker',
		'project' => 'project',
		'company_id' => '_id_firma',
		'user_id' => '_id_uzivatel',
		'company_branch_id' => '_id_pobocka',
		'project_id' => '_id_projekt',
		'project_group_id' => '_id_projekt_skupina',
		'advert_number' => '_cislo',
		'advert_code' => '_kod',
		'listing_annuity' => '_nemovitost_anuita',
		'listing_annuity_currency' => '_nemovitost_anuita_mena',
		'listing_balcony_area' => '_nemovitost_balkon_plocha',
		'listing_balcony' => '_nemovitost_balkon',
		'listing_pool_area' => '_nemovitost_bazen_plocha',
		'listing_pool' => '_nemovitost_bazen',
		'listing_easy_access' => '_nemovitost_bezbarierovy',
		'listing_flat_count' => '_nemovitost_bytu_celkem',
		'advert_price_text_note' => '_nemovitost_cena_poznamka',
		'advert_price_text_note_en' => '_nemovitost_cena_poznamka_en',
		'advert_price_discount_date' => '_nemovitost_cena_datum_snizeni',
		'listing_surroundings_type' => '_nemovitost_charakter_zastavby',
		'listing_nolive_other_area' => '_nemovitost_plocha_nebytovych_prostor',
		'listing_ready_date' => '_nemovitost_datum_nastehovani',
		'listing_length' => '_nemovitost_delka',
		'listing_flat_kind' => '_nemovitost_dispozice',
		'listing_transport' => '_nemovitost_doprava',
		'listing_rent_building_type' => '_nemovitost_druh_bytu',
		'listing_object_type' => '_nemovitost_druh_objektu',
		'listing_estate_kind' => '_nemovitost_druh_pozemku',
		'listing_office_kind' => '_nemovitost_druh_prostor',
		'listing_commercial_kind' => '_nemovitost_ucel_budovy',
		'listing_estate_building_type' => '_nemovitost_druh_stavby',
		'listing_electricity' => '_nemovitost_elektrina',
		'listing_garage_area' => '_nemovitost_garaz_plocha',
		'listing_garage' => '_nemovitost_garaz',
		'listing_engineering_networks' => '_nemovitost_inzenyrske_site',
		'listing_basic_deposit' => '_nemovitost_kauce',
		'listing_construction_elements' => '_nemovitost_konstrukcni_prvky',
		'listing_loggie_area' => '_nemovitost_lodzie_plocha',
		'listing_loggie' => '_nemovitost_lodzie',
		'advert_price_currency' => '_nemovitost_mena',
		'listing_facilities' => '_nemovitost_obcanska_vybavenost',
		'listing_gully' => '_nemovitost_odpad',
		'listing_other' => '_nemovitost_ostatni',
		'listing_nolive_other_description' => '_nemovitost_ostatni_nebytove_prosotry_popis',
		'listing_networks' => '_nemovitost_ostatni_rozvody',
		'listing_other_facilities' => '_nemovitost_ostatni_vybavenost',
		'listing_total_area' => '_nemovitost_plocha_celkova',
		'listing_green_area' => '_nemovitost_plocha_dalsi_zelene',
		'listing_workshop_area' => '_nemovitost_plocha_dilna',
		'listing_workshop_premise_area' => '_nemovitost_plocha_dilny',
		'listing_other_area' => '_nemovitost_plocha_jine',
		'listing_other_area_text' => '_nemovitost_plochy_jine_popis',
		'listing_offices_area' => '_nemovitost_plocha_kancelari',
		'listing_smallest_area' => '_nemovitost_plocha_nejmensi',
		'listing_biggest_area' => '_nemovitost_plocha_nejvetsi',
		'listing_shops_area' => '_nemovitost_plocha_obchodu',
		'listing_building_up_area' => '_nemovitost_plocha_obestavena',
		'listing_plot_area' => '_nemovitost_plocha_parcely',
		'listing_operating_area' => '_nemovitost_plocha_provozni',
		'listing_store_area' => '_nemovitost_plocha_skladu',
		'listing_usable_area' => '_nemovitost_plocha_uzitna',
		'listing_usable_area_attic' => '_nemovitost_plocha_uzitna_podkrovi',
		'listing_usable_area_ground' => '_nemovitost_plocha_uzitna_prizemi',
		'listing_outer_communication_area' => '_nemovitost_plocha_vnejsich_komunikaci',
		'listing_production_area' => '_nemovitost_plocha_vyrobni',
		'listing_garden_area' => '_nemovitost_plocha_zahrada',
		'listing_building_area' => '_nemovitost_plocha_zastavena',
		'listing_gas' => '_nemovitost_plyn',
		'listing_free_flats' => '_nemovitost_pocet_bytu_volnych',
		'listing_office_count' => '_nemovitost_pocet_kancelari',
		'listing_beds' => '_nemovitost_pocet_luzek',
		'listing_seats' => '_nemovitost_pocet_mist',
		'listing_shops# int' => '_nemovitost_pocet_obchodu',
		'listing_floor_count' => '_nemovitost_pocet_podlazi',
		'listing_underground_floors' => '_nemovitost_pocet_podlazi_pod_zemi',
		'listing_free_offices' => '_nemovitost_pocet_volnych_kancelari',
		'listing_floor_number' => '_nemovitost_podlazi_cislo',
		'listing_object_kind' => '_nemovitost_poloha_objektu',
		'listing_description' => '_nemovitost_popis_detailni',
		'listing_description_en' => '_nemovitost_popis_detailni_en',
        'listing_basic_description' => '_nemovitost_popis_zakladni',
        'listing_basic_description_en' => '_nemovitost_popis_zakladni_en',
		'listing_sold_by_parts' => '_nemovitost_prodej_vcelku',
		'listing_garret' => '_nemovitost_pudni_vestavba',
		'listing_acceptance_year# int' => '_nemovitost_rok_kolaudace',
		'listing_reconstruction_year' => '_nemovitost_rok_rekonstrukce',
		'listing_built_year' => '_nemovitost_rok_vystavby',
		'listing_stairs' => '_nemovitost_schodiste',
		'listing_width' => '_nemovitost_sirka',
		'listing_cellar_area' => '_nemovitost_sklep_plocha',
		'listing_cellar' => '_nemovitost_sklep',
		'listing_social' => '_nemovitost_socialni_zarizeni',
		'listing_social_description' => '_nemovitost_socialni_zarizeni_popis',
		'listing_estate_building' => '_nemovitost_stavba_na_pozemku',
		'listing_building_condition' => '_nemovitost_stav_objektu',
		'listing_trees' => '_nemovitost_stromy',
		'listing_telecomunication' => '_nemovitost_telekomunikace',
		'listing_terrace_area' => '_nemovitost_terasa_plocha',
		'listing_terrace' => '_nemovitost_terasa',
		'advert_title' => '_nemovitost_titulek',
		'advert_title_en' => '_nemovitost_titulek_en',
		'listing_heating' => '_nemovitost_topeni',
		'listing_type' => '_nemovitost_typ',
		'listing_house_type' => '_nemovitost_typ_domu',
		'listing_hotel_kind' => '_nemovitost_typ_zarizeni',
		'listing_object_location' => '_nemovitost_umisteni_objektu',
		'listing_protection' => '_nemovitost_umisteni_v_chranenych_lokalitach',
		'advert_virtual_tour_url' => '_nemovitost_virtualni_prohlidka',
		'listing_ownership' => '_nemovitost_vlastnictvi',
		'listing_estate_area' => '_nemovitost_vlastni_pozemek',
		'listing_water' => '_nemovitost_voda',
		'listing_flat_facilities' => '_nemovitost_vybaveni_byt',
		'listing_office_equipment' => '_nemovitost_vybaveni_kancelari',
		'listing_office_equipment_description' => '_nemovitost_vybaveni_kancelari_popis',
		'listing_office_equipment_description_en' => '_nemovitost_vybaveni_kancelari_popis_en',
		'listing_commercial_area_equipment' => '_nemovitost_vybaveni_komercnich_prostor',
		'listing_commercial_area_equipment_description' => '_nemovitost_vybaveni_komercnich_prostor_popis',
		'listing_equipment' => '_nemovitost_vybaveno',
		'listing_equipment_description' => '_nemovitost_vybaveno_popis',
		'listing_equipment_description_en' => '_nemovitost_vybaveno_popis_en',
		'listing_height' => '_nemovitost_vyska',
		'listing_ceiling_height' => '_nemovitost_vyska_stropu',
		'advert_price_hidden' => '_nezobrazovat_cenu',
		'listing_parking_place_count' => '_pocet_mist_k_parkovani',
		'edited' => '_zakazka_datum_editace',
		'created' => '_zakazka_datum_vlozeno',
		'advert_status' => '_zakazka_stav',
		'advert_type' => '_zakazka_typ',
		'advert_comission_amount' => '_zakazka_provize_celkem',
		'advert_comission_percent' => '_zakazka_provize_procenta',
		'listing_locality_municipality_part_code' => '_nemovitost_uir_cobce_kod',
		'listing_locality_municipality_part' => '_nemovitost_uir_cobce_text',
		'listing_locality_county_code' => '_nemovitost_uir_kraj_kod',
		'listing_locality_county' => '_nemovitost_uir_kraj_text',
		'listing_locality_city_part_code' => '_nemovitost_uir_mcast_kod',
		'listing_locality_city_part' => '_nemovitost_uir_mcast_text',
		'listing_locality_municipality_code' => '_nemovitost_uir_obec_kod',
		'listing_locality_municipality' => '_nemovitost_uir_obec_text',
		'listing_locality_region_code' => '_nemovitost_uir_okres_kod',
		'listing_locality_region' => '_nemovitost_uir_okres_text',
		'listing_locality_prague_district_code' => '_nemovitost_uir_pobvod_kod',
		'listing_locality_prague_district' => '_nemovitost_uir_pobvod_text',
		'listing_locality_street_code' => '_nemovitost_uir_ulice_kod',
		'listing_locality_street' => '_nemovitost_uir_ulice_text',
		'listing_locality_cp' => '_nemovitost_uir_cp',
		'listing_locality_co' => '_nemovitost_uir_co',
		'listing_locality_country_code' => '_nemovitost_uir_stat',
		'listing_object_name' => '_nemovitost_objekt',
		'project_developer_internal_number' => '_zakazka_interni_cislo_developera',
		'advert_use_project_photos' => '_zakazka_pouzit_foto_projektu',
		'advert_contract_type' => '_zakazka_typ_smlouvy',
		'listing_energy_efficiency_rating' => '_nemovitost_energeticky_stitek',
		'listing_energy_performance_summary' => '_nemovitost_merna_rocni_spotreba',
		'listing_energy_performance_certificate' => '_nemovitost_energeticky_stitek_vyhlaska',
		'listing_energy_performance_attachment' => '_nemovitost_energeticky_stitek_priloha',
		'listing_locality_latitude' => '_nabidka_gps_x',
		'listing_locality_longitude' => '_nabidka_gps_y',
		'listing_locality_inaccuracy_level' => '_nabidka_gps_presnost',
		'advert_commercial_collection_residential' => '_oznaceni_res_com_col',
		'has_open_day' => '_nemovitost_openhouse',
		'open_day' => '_nemovitost_openhouse_datum',
		'open_day_to' => '_nemovitost_openhouse_datum_do',
		'listing_elevator' => '_nemovitost_vytah',
		'listing_room_count' => '_nemovitost_pocet_pokoju',
		'attachments' => 'attachments',
	);

	public function __get($property)
	{
		if ($property === 'listing_subtype') {
			$property = $this->getSubtypePropertyName();
			if ($property === null) {
				return null;
			}
		} elseif ($property === 'listing_main_area') {
			$property = $this->getMainAreaPropertyName();
			if ($property === null) {
				return 0;
			}
		} elseif ($property === 'advert_total_amount') {
			return $this->getTotalAmount();
		} elseif ($property === 'advert_price') {
			return $this->getPrice();
		} elseif ($property === 'advert_price_unit') {
			return $this->getPriceUnit();
		} elseif ($property === 'id') {
			return $this->id;
		} elseif ($property === 'broker') {
			return $this->broker;
		}
		if (isset(self::$_map[$property])) {
			return $this->{self::$_map[$property]};
		}

		throw new InvalidPropertyException(sprintf('No property "%s" to get', $property));
	}

	public function __isset($property)
	{
		if (in_array($property, ['listing_subtype', 'listing_main_area', 'advert_price', 'advert_price_unit'])) {
			return true;
		} elseif (isset(self::$_map[$property]) || property_exists($this, $property)) {
			return true;
		}

		return false;
	}

	/**
	 * Vrací název vlastnosti s podtypem nemovitosti.
	 *
	 * Pokud nemovitost nemá podtyp, vrací null.
	 *
	 * Pro komerční objekty a prostory vrací správný podtyp (druh prostor a nebo druh objektu).
	 *
	 * @return string|null Název vlastnosti s podtypem nemovitosti.
	 */
	public function getSubtypePropertyName()
	{
		$type = $this->listing_type;

		return isset(self::$subTypeMappings[$type]) ? self::$subTypeMappings[$type] : null;
	}

	/**
	 * Vrací název proměnné (var_name z variables) s podtypem nemovitosti.
	 *
	 * Pokud nemovitost nemá podtyp, vrací null.
	 *
	 * @return string|null Název proměnné s podtypem nemovitosti.
	 */
	public function getSubtypeVariableName()
	{
		$type = $this->listing_type;

		return isset(self::$legacySubTypeMappings[$type]) ? self::$legacySubTypeMappings[$type] : null;
	}

	/**
	 * Vrací název vlastnosti s hlavní plochou nemovitosti.
	 *
	 * Pokud nemovitost nemá hlavní plochu, vrací null.
	 *
	 * @return string|null Název vlastnosti s hlavní plochou nemovitosti.
	 */
	public function getMainAreaPropertyName()
	{
		$type = $this->listing_type;

		return isset(self::$areaMappings[$type]) ? self::$areaMappings[$type] : null;
	}

	public function getPrice()
	{
		if ($this->isForSale()) {
			return $this->_nemovitost_cena_prodej;
		} elseif ($this->isForLease()) {
			return $this->_nemovitost_cena_pronajem;
		}

		return null;
	}

	public function getPriceUnit()
	{
		if ($this->isForSale()) {
			return $this->_nemovitost_cena_prodej_jednotka;
		} elseif ($this->isForLease()) {
			return $this->_nemovitost_cena_pronajem_jednotka;
		}

		return 0;
	}

	/**
	 * Vrátí objem zakázky.
	 *
	 * V případě prodeje je objem zakázky cena za nemovitost.
	 * V případě pronájmu je objem zakázky cena za nemovitost za měsíc.
	 *
	 * @return float Objem zakázky.
	 */
	public function getTotalAmount()
	{
		switch ($this->advert_price_unit) {
			case 3: // za m2
			case 4:
				$area = $this->getMainAreaPropertyName();

				return $this->advert_price * $this->$area;

			case 5: // za m2/rok
				$area = $this->getMainAreaPropertyName();

				return $this->advert_price * $this->$area / 12;

			case 6: // za rok
				return $this->advert_price / 12;

			case 7: // za den
				return $this->advert_price * 30;

			case 8: // za hodinu
				return $this->advert_price * 24 * 30;

			default:
				return $this->advert_price;
		}
	}

	/**
	 * Je zakázka pronájem?
	 *
	 * @return bool True pokud je zakázka pronájem, jinak false.
	 */
	public function isForLease()
	{
		return $this->__get('advert_type') === self::ADVERT_LEASE;
	}

	/**
	 * Je zakázka prodej?
	 *
	 * @return bool True pokud je zakázka prodej, jinak false.
	 */
	public function isForSale()
	{
		return $this->__get('advert_type') === self::ADVERT_SELL;
	}

	/**
	 * Je nomovitost prodaná nebo pronajatá?
	 *
	 * @return bool
	 */
	public function isSoldOrLeased()
	{
		return $this->advert_status === self::ADVERT_STATUS_SOLD_OR_LEASED;
	}

	/**
	 * Je nemovitost rezervovaná?
	 *
	 * @return bool
	 */
	public function isReserved()
	{
		return $this->advert_status === self::ADVERT_STATUS_RESERVED;
	}

	/**
	 * Je nemovitost aktivní?
	 *
	 * @return bool
	 */
	public function isActive()
	{
		return $this->advert_status === self::ADVERT_STATUS_ACTIVE;
	}

	/**
	 * Získá obrázky nabídky.
	 *
	 * @return ListingAttachment[]
	 */
	public function getImages()
	{
		$ret = [];
		foreach ($this->attachments as $attachment) {
			if ($attachment->isImage()) {
				$ret[] = $attachment;
			}
		}

		usort($ret, function ($firstAttachment, $secondAttachment) {
			/** @var ListingAttachment $firstAttachment */
			/** @var ListingAttachment $secondAttachment */
			$first = $firstAttachment->order;
			$second = $secondAttachment->order;

			if ($first == $second) {
				return 0;
			}

			return $first > $second ? 1 : -1;
		});

		return $ret;
	}

	/**
	 * Vrátí popis v jazyce dle předané locale.
	 *
	 * @param string $locale Dvoupísmenná locale (cs, en).
	 *
	 * @return string Lokalizovaný popis.
	 *
	 * @throws InvalidLocaleException Pokud není locale podporována.
	 */
	public function getLocalizedDescription($locale)
	{
		return $this->_getLocalizedProperty('listing_description', $locale);
	}

    /**
     * Vrátí popis základní v jazyce dle předané locale.
     *
     * @param string $locale Dvoupísmenná locale (cs, en).
     *
     * @return string Lokalizovaný popis.
     *
     * @throws InvalidLocaleException Pokud není locale podporována.
     */
    public function getLocalizedBasicDescription($locale)
    {
        return $this->_getLocalizedProperty('listing_basic_description', $locale);
    }

	/**
	 * Vrátí titulek v jazyce dle předané locale.
	 *
	 * @param string $locale Dvoupísmenná locale (cs, en).
	 *
	 * @return string Lokalizovaný titulek.
	 *
	 * @throws InvalidLocaleException Pokud není locale podporována.
	 */
	public function getLocalizedTitle($locale)
	{
		return $this->_getLocalizedProperty('advert_title', $locale);
	}

	/**
	 * Vrátí poznámku k ceně v jazyce dle předané locale.
	 *
	 * @param string $locale Dvoupísmenná locale (cs, en).
	 *
	 * @return string Lokalizovaná poznámka k ceně.
	 *
	 * @throws InvalidLocaleException Pokud není locale podporována.
	 */
	public function getLocalizedPriceTextNote($locale)
	{
		return $this->_getLocalizedProperty('advert_price_text_note', $locale);
	}

	/**
	 * Vrátí popis komerčních prostor v jazyce dle předané locale.
	 *
	 * @param string $locale Dvoupísmenná locale (cs, en).
	 *
	 * @return string Lokalizovaný popis komerčních prostor.
	 *
	 * @throws InvalidLocaleException Pokud není locale podporována.
	 */
	public function getLocalizedCommercialAreaEquipmentDescription($locale)
	{
		return $this->_getLocalizedProperty('listing_commercial_area_equipment_description', $locale);
	}

	/**
	 * Vrátí popis vybavení v jazyce dle předané locale.
	 *
	 * @param string $locale Dvoupísmenná locale (cs, en).
	 *
	 * @return string Lokalizovaný popis vybavení.
	 *
	 * @throws InvalidLocaleException Pokud není locale podporována.
	 */
	public function getLocalizedEquipmentDescription($locale)
	{
		return $this->_getLocalizedProperty('listing_equipment_description', $locale);
	}

	/**
	 * Vrátí hodnotu vlastnosti na základě názvu české vlastnosti a locale.
	 *
	 * @param string $propertyName Název vlastnosti v českém tvaru (bez suffixu).
	 * @param string $locale       Dvoupísmenná locale (cs, en).
	 *
	 * @return mixed Hodnota dané vlastnosti.
	 *
	 * @throws InvalidLocaleException Pokud není locale podporována.
	 */
	private function _getLocalizedProperty($propertyName, $locale)
	{
		if ($locale === 'en') {
			$propertyName .= '_en';
		} elseif ($locale !== 'cs') {
			throw new InvalidLocaleException(sprintf('Nepodporovaná locale "%s"', $locale));
		}

		return $this->$propertyName;
	}
}
