<?php
/**
 * Created by PhpStorm.
 * User: rbas
 * Date: 11/11/13
 * Time: 3:22 PM
 */
namespace Dalten\WebBundle\Filter\Converter;

use Dalten\WebBundle\Filter\ListingFilter;


/**
 * Převodní třída, která má z pole parametrů query string vytvořit instanci obecného filtru.
 */
interface ListingListInterface
{
	/**
	 * Vytvoří filtr na základě pole zdrojových dat.
	 *
	 * @param array $filterData Zdrojová data filtru.
	 *
	 * @return ListingFilter Vytvořená instance filtru.
	 */
	public function createFilterFromArray(array $filterData);

	/**
	 * Vytvoří pole parametrů ve formátu query string z instance ListingFilter.
	 *
	 * @param \Dalten\WebBundle\Filter\ListingFilter $filter Vyplněný filtr nabídek.
	 *
	 * @return array Pole parametrů do query stringu, získaných z filtru.
	 */
	public function getRouteParamsFromFilter(ListingFilter $filter);
}
