<?php

namespace Dalten\WebBundle\Filter;

/**
 * Rozhraní pro filtr nemovitostí.
 *
 * @package Dalten\WebBundle\Filter
 */
interface FilterInterface
{
	/**
	 * Vrátí hodnotu dané proměné filtru.
	 *
	 * @param string $name Název požadované proměné.
	 *
	 * @return mixed
	 *
	 * @throw \Dalten\Exception\DoesNotExistError Pokud požadovaná položka neexistuje.
	 */
	public function __get($name);

	/**
	 * Zjistí zda požadované proměná je ve filtru.
	 *
	 * @param string $name Název požadované proměné.
	 *
	 * @return mixed
	 */
	public function __isset($name);
}
