<?php
namespace Dalten\WebBundle\Processor\TitleGenerator\ListingList;

use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Processor\TitleGenerator\AbstractAddress;

/**
 * Generátor adresní část titulku k výpisům nemovitostí.
 *
 * Tento generátor tvoří pouze titulky na základě adresy, neřeší další části titulku.
 */
class Address extends AbstractAddress implements GeneratorInterface
{

	/**
	 * Vytvoří z předaného filtru titulek pro výpis.
	 *
	 * Vytváří pouze adresní část titulku, typ nemovitosti a další části neřeší, tj. je vhodný na začlenění
	 * do specifičtějších generátorů.
	 *
	 * @param ListingFilter $filter Vyplněný filtr nabídek.
	 *
	 * @return string Vytvořený titulek pro filtr.
	 */
	public function createTitle(ListingFilter $filter)
	{
		return $this->_createTitle($filter);
	}
}
