<?php
namespace Dalten\WebBundle\Twig\Extensions\Extension;

/**
 * Rozšíření pro práci s řetězci.
 */
class StringUtils extends \Twig_Extension
{
	/**
	 * Vrátí seznam filtrů.
	 *
	 * @return array
	 */
	public function getFilters()
	{
		return array(
			'truncateChars' => new \Twig_Filter_Function('Dalten\Util\StringHelper::cut'),
			'deaccent' => new \Twig_Filter_Function('Dalten\Util\StringHelper::utf2ascii'),
			'slugify' => new \Twig_Filter_Function('Dalten\Util\StringHelper::slugify'),
		);
	}

	/**
	 * Returns the name of the extension.
	 *
	 * @return string The extension name
	 */
	function getName()
	{
		return 'stringUtils';
	}

}
