<?php

namespace Dalten\Tests\Util;

use Dalten\Util\ArrayHelper;

/**
 * Test class for ArrayHelper.
 * Generated by PHPUnit on 2011-01-03 at 11:21:10.
 */
class ArrayHelperTest extends \PHPUnit_Framework_TestCase
{

	public function testCollectPropertiesReturnsPropertyValuesOfAllObjectsInArray()
	{
		$items = array(
			(object) array('test' => 2, 'ahoj' => 3),
			(object) array('test' => 'x'),
			(object) array('test' => -9),
		);

		$this->assertSame(array(2, 'x', -9), ArrayHelper::collectProperties($items, 'test'));
	}

	public function testBuildIndexedCollection()
	{
		$collection = array(
			(object) array('test' => 2, 'ahoj' => 3),
			(object) array('test' => 'x'),
			(object) array('test' => -9),
		);

		$result = ArrayHelper::buildIndexedCollection($collection, 'test');
		$this->assertSame($collection[1], $result['x']);
	}

	public function testBuildArrayByKey()
	{
		$items = array(
			array('test' => 2, 'ahoj' => 3),
			array('test' => 'x'),
			array('test' => -9),
		);

		$result = ArrayHelper::buildArrayByKey($items, 'test');
		$this->assertSame($items[1], $result['x']);
	}

	public function testRecursiveToFilterNames()
	{
		$values = array(
			'param1' => array(
				'param1value1' => 1,
				'param1value2' => 2,
				'param1value3' => array(
					'param1Value3Value1' => 1,
					'param1Value3Value2' => 2,
					'param1Value3Value3' => array(
						'param1Value3Value3Value3Value1' => 1,
						'param1Value3Value3Value3Value2' => 2,
					),
				),
			),
			'types' => array(
				'4' => array(
					1 => 'on',
					2 => 'on',
				)
			)
		);
		$result = ArrayHelper::recursiveToFilterNames($values);

		$expected = array(
			'param1' => 'on',
			'param1[param1value1]' => 1,
			'param1[param1value2]' => 2,
			'param1[param1value3]' => 'on',
			'param1[param1value3][param1Value3Value1]' => 1,
			'param1[param1value3][param1Value3Value2]' => 2,
			'param1[param1value3][param1Value3Value3]' => 'on',
			'param1[param1value3][param1Value3Value3][param1Value3Value3Value3Value1]' => 1,
			'param1[param1value3][param1Value3Value3][param1Value3Value3Value3Value2]' => 2,
			'types' => 'on',
			'types[4]' => 'on',
			'types[4][1]' => 'on',
			'types[4][2]' => 'on',
		);

		$this->assertSame($expected, $result);
	}

	public function testRecursiveKsort()
	{
		$value = array(
			'types' => array(
				4 => array(
					5 => 'on',
					1 => 'on',
				)
			),
			'arg' => 'xxx'
		);

		$expectedResult = array(
			'arg' => 'xxx',
			'types' => array(
				4 => array(
					1 => 'on',
					5 => 'on'
				)
			)
		);

		ArrayHelper::ksortRecursive($value);
		$this->assertEquals($expectedResult, $value);
	}

	/**
	 * @dataProvider multiOptionToStringConversionDataProvider
	 */
	public function testConvertToMultiOptionString(array $input, $expected)
	{
		$this->assertSame($expected, ArrayHelper::convertToMultiOptionString($input));
	}

	public function multiOptionToStringConversionDataProvider()
	{
		return array(
			'empty_array=empty_string' => array(array(), ''),
			'array(0)=string(1)' => array(array(0), '1'),
			'array(1,3)=string(0101)' => array(array(1,3), '0101'),
			'array(-1)=empty_string' => array(array(-1), '')
		);
	}
}
