<?php
namespace Dalten\WebBundle\Test\Breadcrumbs\Listing\Builder;

use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Entity\Listing;
use Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingType;
use Mockery as m;

class ListingTypeTest extends \PHPUnit_Framework_TestCase
{
	private $_defaultConfig = array(
		'routeName' => 'test',
		'valueMap' => array(
			'komercni-nemovitosti' => array(
				'acceptedValues' => array(91, 2, 9), 'label' => 'Komerční nemovitosti',
				'routeParams'=> array('listing_type' => 'komercni-nemovitosti')
			),
			'zemedelske-objekty' => array(
				'acceptedValues' => array(1), 'label' => 'Zemědělské objekty',
				'routeParams'=> array('listing_type' => 'zemedelske-objekty')
			),
            'byty' => array('acceptedValues' => array(4), 'label' => 'Byty', 'routeParams' => array('listing_type' => 'byty'))
		)
	);

	/**
	 * @dataProvider listingTypeAndExpectedSlugAndLabelProvider
	 */
	public function testCreateBreadcrumbFromFilterReturnsSpecifiedBreadcrumb($listingType, $expectedSlug, $expectedLabel)
	{
		$builder = new ListingType($this->_defaultConfig);
		$filter = new ListingFilter(array('listing_type' => $listingType));
		$breadcrumb = $builder->getBreadcrumbFromFilter($filter);

		$this->assertNotNull($breadcrumb);
		$this->assertSame($expectedLabel, $breadcrumb->getLabel());
		$this->assertSame($this->_defaultConfig['routeName'], $breadcrumb->getRouteName());
		$this->assertSame(array('listing_type' => $expectedSlug), $breadcrumb->getRouteParams());
	}

	/**
	 * @dataProvider listingTypeAndExpectedSlugAndLabelProvider
	 */
	public function testCreateBreadcrumbFromListingReturnsSpecifiedBreadcrumb($listingType, $expectedSlug, $expectedLabel)
	{
		$builder = new ListingType($this->_defaultConfig);
		$listing = new Listing;
		$listing->listing_type = $listingType;
		$breadcrumb = $builder->getBreadcrumbFromListing($listing);

		$this->assertSame($expectedLabel, $breadcrumb->getLabel());
		$this->assertSame($this->_defaultConfig['routeName'], $breadcrumb->getRouteName());
		$this->assertSame(array('listing_type' => $expectedSlug), $breadcrumb->getRouteParams());
	}


	/**
	 * @dataProvider invalidListingTypeProvider
	 */
	public function testCreateBreadcrumbFromFilterReturnsNullIfInvalidListingTypeIsSet($listingType)
	{
		$builder = new ListingType($this->_defaultConfig);
		$filter = new ListingFilter(array('listing_type' => $listingType));
		$breadcrumb = $builder->getBreadcrumbFromFilter($filter);

		$this->assertNull($breadcrumb);
	}

	/**
	 * @dataProvider invalidListingTypeProvider
	 */
	public function testCreateBreadcrumbFromListingReturnsNullIfInvalidListingTypeIsSet($listingType)
	{
		$builder = new ListingType($this->_defaultConfig);
		$listing = new Listing;
		$listing->listing_type = $listingType;
		$breadcrumb = $builder->getBreadcrumbFromListing($listing);

		$this->assertNull($breadcrumb);
	}



	public function listingTypeAndExpectedSlugAndLabelProvider()
	{
		return array(
			'byty(4)' => array(4, 'byty', 'Byty'),
			'zemedelske-objekty(1)' => array(1, 'zemedelske-objekty', 'Zemědělské objekty'),
			'komercni-nemovitosti(91)' => array(91, 'komercni-nemovitosti', 'Komerční nemovitosti'),
		);
	}
	public function invalidListingTypeProvider()
	{
		return array(
			'byty(4)' => array(99),
			'komercni-nemovitosti(1)' => array(87),
			'komercni-nemovitosti(91)' => array(69),
		);
	}

}
