<?php

namespace Dalten\WebBundle\Breadcrumbs\Company\Builder;

use Dalten\WebBundle\Filter\CompanyFilter;
use Dalten\WebBundle\Entity\Company;
use Dalten\WebBundle\Breadcrumbs\Breadcrumb;
use Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface;

/**
 * Builder na drobek, reprezentující odkaz na firmu.
 */
class CompanyName implements BuilderInterface
{
	/**
	 * Konfigurace drobka.
	 *
	 * @var array
	 */
	private $_config;

	/**
	 * Nastavuje konfiguraci.
	 *
	 * Parametrem by mělo být pole s klíči: routeName a routeParams.
	 *
	 * @param array $config Pole konfiguračních možností.
	 */
	public function __construct(array $config)
	{
		$this->_config = $config;
	}

	/**
	 * Vytvoří drobka z vyplněného modelu nabídky.
	 *
	 * Pokud není prázdné pole routeParams v configu, tak bude zkombinováno se slugem firmy.
	 *
	 * @param Company $company Model firmy.
	 *
	 * @return BreadcrumbInterface|null Drobek nebo null.
	 */
	public function getBreadcrumbFromCompany(Company $company)
	{
		$params = array_merge($this->_config['routeParams'], array('company_slug' => $company->slug));
		return new Breadcrumb($company->name, $this->_config['routeName'], $params);
	}

	/**
	 * Vytvoří drobka z vyplněného filtru firem.
	 *
	 * Na filtr se v tomto případě nebere ohled, vrácený drobek ukazuje vždy na stejnou routu.
	 *
	 * @param CompanyFilter $filter Vyplněný filtr firem.
	 *
	 * @return null Null, protože z filtru nelze určit firmu.
	 */
	public function getBreadcrumbFromFilter(CompanyFilter $filter)
	{
		return null;
	}
}
