<?php

namespace Dalten\WebBundle\Breadcrumbs\Company\Collection;

use Dalten\WebBundle\Filter\CompanyFilter;
use Dalten\WebBundle\Entity\Company;
use Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface;
use Dalten\WebBundle\Breadcrumbs\Company\Builder\BuilderInterface;

/**
 * Tvořič kolekcí drobečků.
 */
class Builder
{
	/**
	 * Pole tvořičů drobečků.
	 *
	 * @var BuilderInterface[]
	 */
	private $_builders;

	/**
	 * Nastavuje pole builderů drobečků.
	 *
	 * @param BuilderInterface[] $builders Tvořiče drobečků.
	 */
	public function __construct(array $builders = array())
	{
		$this->_builders = $builders;
	}

	/**
	 * Vytvoří pole drobečků z firmy.
	 *
	 * @param Company $company Model firmy.
	 *
	 * @return BreadcrumbInterface[] Drobky.
	 */
	public function getBreadcrumbsFromCompany(Company $company)
	{
		$crumbs = array();
		foreach ($this->_builders as $builder) {
			$crumbs[] = $builder->getBreadcrumbFromCompany($company);
		}

		return array_filter($crumbs);
	}

	/**
	 * Vytvoří pole drobečků z filtru nabídek.
	 *
	 * @param CompanyFilter $filter Filtr firem.
	 *
	 * @return BreadcrumbInterface[] Drobky.
	 */
	public function getBreadcrumbsFromFilter(CompanyFilter $filter)
	{
		$crumbs = array();
		foreach ($this->_builders as $builder) {
			$crumbs[] = $builder->getBreadcrumbFromFilter($filter);
		}

		return array_filter($crumbs);
	}
}
