<?php

namespace Dalten\WebBundle\Breadcrumbs\Listing\Builder;

use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Entity\Listing;
use Dalten\WebBundle\Breadcrumbs\Breadcrumb;
use Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface;

/**
 * Builder na drobek, reprezentující statickou url.
 */
class StaticRoute implements BuilderInterface
{
	/**
	 * Konfigurace drobka.
	 *
	 * @var array
	 */
	private $_config;

	/**
	 * Nastavuje konfiguraci.
	 *
	 * Parametrem by mělo být pole s klíči: label, routeName a routeParams (pole).
	 *
	 * @param array $config Pole konfiguračních možností.
	 */
	public function __construct(array $config)
	{
		$this->_config = $config;
	}

	/**
	 * Vytvoří drobka z vyplněného modelu nabídky.
	 *
	 * Na nabídku se v tomto případě nebere ohled, vrácený drobek ukazuje vždy na stejnou routu.
	 *
	 * @param Listing $listing Model nabídky.
	 *
	 * @return BreadcrumbInterface|null Drobek nebo null.
	 */
	public function getBreadcrumbFromListing(Listing $listing)
	{
		return $this->_getBreadcrumb();
	}

	/**
	 * Vytvoří drobka z vyplněného filtru nabídek.
	 *
	 * Na filtr se v tomto případě nebere ohled, vrácený drobek ukazuje vždy na stejnou routu.
	 *
	 * @param ListingFilter $filter Vyplněný filtr nabídek.
	 *
	 * @return BreadcrumbInterface|null Drobek nebo null.
	 */
	public function getBreadcrumbFromFilter(ListingFilter $filter)
	{
		return $this->_getBreadcrumb();
	}

	/**
	 * Vytvoří model drobečku z configu a vrátí jej.
	 *
	 * @return null|BreadcrumbInterface Drobek nebo null pokud jej nelze vytvořit.
	 */
	private function _getBreadcrumb()
	{
		return new Breadcrumb(
			$this->_config['label'], $this->_config['routeName'], $this->_config['routeParams']
		);
	}
}
